/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SDD
extends AbstractSegment {
    public SDD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 11, new Object[]{this.getMessage()}, "Lot Number");
            this.add(EI.class, false, 1, 8, new Object[]{this.getMessage()}, "Device Number");
            this.add(ST.class, false, 1, 999, new Object[]{this.getMessage()}, "Device Name");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(667)}, "Device Data State");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(669)}, "Load Status");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Control Code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Operator Name");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SDD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getLotNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getSdd1_LotNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getDeviceNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSdd2_DeviceNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getDeviceName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSdd3_DeviceName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getDeviceDataState() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getSdd4_DeviceDataState() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getLoadStatus() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getSdd5_LoadStatus() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getControlCode() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getSdd6_ControlCode() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getOperatorName() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getSdd7_OperatorName() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(667));
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(669));
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

