/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPointer
extends Pointer {
    private static final Logger log = LoggerFactory.getLogger(SegmentPointer.class);
    private PipeParser parser;
    private Group parent;
    private String name;
    private EncodingCharacters encodingChars;
    private boolean repeating;
    private Segment currSegment = null;
    private boolean currSegmentFull = true;

    public SegmentPointer(PipeParser parser, Group parent, int position, EncodingCharacters encodingChars) throws HL7Exception {
        this.parser = parser;
        this.parent = parent;
        this.encodingChars = encodingChars;
        this.name = parent.getNames()[position];
        this.repeating = parent.isRepeating(this.name);
    }

    public int setSegment(String segment, boolean correctOrder) throws HL7Exception {
        int status = 0;
        if (segment.substring(0, 3).equals(this.name)) {
            if (correctOrder) {
                if (this.prepEmptyInstance()) {
                    try {
                        this.parser.parse(this.currSegment, segment, this.encodingChars);
                    }
                    catch (HL7Exception e) {
                        e.setSegmentName(this.name);
                        throw e;
                    }
                    this.currSegmentFull = true;
                    status = 2;
                } else {
                    status = 1;
                }
            } else {
                status = 3;
            }
        }
        log.debug("Attempt to put segment " + segment.substring(0, 3) + " in " + this.name + ": code = " + status);
        return status;
    }

    private boolean prepEmptyInstance() throws HL7Exception {
        boolean success = false;
        if (this.currSegment == null || this.repeating && this.currSegmentFull) {
            int numExisting = this.parent.getAll(this.name).length;
            this.currSegment = (Segment)this.parent.get(this.name, numExisting);
            this.currSegmentFull = false;
            success = true;
        } else if (!this.currSegmentFull) {
            success = true;
        }
        return success;
    }
}

