/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RGS
extends AbstractSegment {
    public RGS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - RGS");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Resource Group ID");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RGS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDRGS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getRgs1_SetIDRGS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getRgs2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getResourceGroupID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRgs3_ResourceGroupID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

