/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CE;
import ca.uhn.hl7v2.model.v21.datatype.CM;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.CQ;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TN;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBR
extends AbstractSegment {
    public OBR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "SET ID - OBSERVATION REQUEST");
            this.add(CM.class, false, 1, 75, new Object[]{this.getMessage()}, "PLACER ORDER #");
            this.add(CM.class, false, 1, 75, new Object[]{this.getMessage()}, "FILLER ORDER #");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "UNIVERSAL SERVICE IDENT.");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "PRIORITY");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "REQUESTED DATE-TIME");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage()}, "OBSERVATION DATE/TIME");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage()}, "OBSERVATION END DATE/TIME");
            this.add(CQ.class, true, 1, 20, new Object[]{this.getMessage()}, "COLLECTION VOLUME");
            this.add(CN.class, false, 0, 60, new Object[]{this.getMessage()}, "COLLECTOR IDENTIFIER");
            this.add(ST.class, false, 1, 1, new Object[]{this.getMessage()}, "SPECIMEN ACTION CODE");
            this.add(CM.class, false, 1, 60, new Object[]{this.getMessage()}, "DANGER CODE");
            this.add(ST.class, false, 1, 300, new Object[]{this.getMessage()}, "RELEVANT CLINICAL INFO.");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage()}, "SPECIMEN RECEIVED DATE/TIME");
            this.add(CM.class, false, 1, 300, new Object[]{this.getMessage()}, "SPECIMEN SOURCE");
            this.add(CN.class, false, 0, 60, new Object[]{this.getMessage()}, "ORDERING PROVIDER");
            this.add(TN.class, false, 2, 40, new Object[]{this.getMessage()}, "ORDER CALL-BACK PHONE NUM");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "PLACERS FIELD #1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "PLACERS FIELD #2");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "FILLERS FIELD #1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "FILLERS FIELD #2");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage()}, "RESULTS RPT/STATUS CHNG - DATE/T");
            this.add(CM.class, false, 1, 40, new Object[]{this.getMessage()}, "CHARGE TO PRACTICE");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(74)}, "DIAGNOSTIC SERV SECT ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(123)}, "RESULT STATUS");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "LINKED RESULTS");
            this.add(CM.class, false, 0, 200, new Object[]{this.getMessage()}, "QUANTITY/TIMING");
            this.add(CN.class, false, 5, 80, new Object[]{this.getMessage()}, "RESULT COPIES TO");
            this.add(CM.class, false, 1, 150, new Object[]{this.getMessage()}, "PARENT ACCESSION #");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(124)}, "TRANSPORTATION MODE");
            this.add(CE.class, false, 0, 300, new Object[]{this.getMessage()}, "REASON FOR STUDY");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "PRINCIPAL RESULT INTERPRETER");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "ASSISTANT RESULT INTERPRETER");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "TECHNICIAN");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "TRANSCRIPTIONIST");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "SCHEDULED - DATE/TIME");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OBR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSETIDOBSERVATIONREQUEST() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObr1_SETIDOBSERVATIONREQUEST() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CM getPLACERORDER() {
        CM retVal = (CM)this.getTypedField(2, 0);
        return retVal;
    }

    public CM getObr2_PLACERORDER() {
        CM retVal = (CM)this.getTypedField(2, 0);
        return retVal;
    }

    public CM getFILLERORDER() {
        CM retVal = (CM)this.getTypedField(3, 0);
        return retVal;
    }

    public CM getObr3_FILLERORDER() {
        CM retVal = (CM)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getUNIVERSALSERVICEIDENT() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getObr4_UNIVERSALSERVICEIDENT() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPRIORITY() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getObr5_PRIORITY() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getREQUESTEDDATETIME() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getObr6_REQUESTEDDATETIME() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getOBSERVATIONDATETIME() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getObr7_OBSERVATIONDATETIME() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getOBSERVATIONENDDATETIME() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getObr8_OBSERVATIONENDDATETIME() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getCOLLECTIONVOLUME() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getObr9_COLLECTIONVOLUME() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CN[] getCOLLECTORIDENTIFIER() {
        CN[] retVal = (CN[])this.getTypedField(10, new CN[0]);
        return retVal;
    }

    public CN[] getObr10_COLLECTORIDENTIFIER() {
        CN[] retVal = (CN[])this.getTypedField(10, new CN[0]);
        return retVal;
    }

    public int getCOLLECTORIDENTIFIERReps() {
        return this.getReps(10);
    }

    public CN getCOLLECTORIDENTIFIER(int rep) {
        CN retVal = (CN)this.getTypedField(10, rep);
        return retVal;
    }

    public CN getObr10_COLLECTORIDENTIFIER(int rep) {
        CN retVal = (CN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getObr10_COLLECTORIDENTIFIERReps() {
        return this.getReps(10);
    }

    public CN insertCOLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(10, rep);
    }

    public CN insertObr10_COLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(10, rep);
    }

    public CN removeCOLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(10, rep);
    }

    public CN removeObr10_COLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(10, rep);
    }

    public ST getSPECIMENACTIONCODE() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getObr11_SPECIMENACTIONCODE() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public CM getDANGERCODE() {
        CM retVal = (CM)this.getTypedField(12, 0);
        return retVal;
    }

    public CM getObr12_DANGERCODE() {
        CM retVal = (CM)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRELEVANTCLINICALINFO() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObr13_RELEVANTCLINICALINFO() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getSPECIMENRECEIVEDDATETIME() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getObr14_SPECIMENRECEIVEDDATETIME() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public CM getSPECIMENSOURCE() {
        CM retVal = (CM)this.getTypedField(15, 0);
        return retVal;
    }

    public CM getObr15_SPECIMENSOURCE() {
        CM retVal = (CM)this.getTypedField(15, 0);
        return retVal;
    }

    public CN[] getORDERINGPROVIDER() {
        CN[] retVal = (CN[])this.getTypedField(16, new CN[0]);
        return retVal;
    }

    public CN[] getObr16_ORDERINGPROVIDER() {
        CN[] retVal = (CN[])this.getTypedField(16, new CN[0]);
        return retVal;
    }

    public int getORDERINGPROVIDERReps() {
        return this.getReps(16);
    }

    public CN getORDERINGPROVIDER(int rep) {
        CN retVal = (CN)this.getTypedField(16, rep);
        return retVal;
    }

    public CN getObr16_ORDERINGPROVIDER(int rep) {
        CN retVal = (CN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getObr16_ORDERINGPROVIDERReps() {
        return this.getReps(16);
    }

    public CN insertORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(16, rep);
    }

    public CN insertObr16_ORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(16, rep);
    }

    public CN removeORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(16, rep);
    }

    public CN removeObr16_ORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(16, rep);
    }

    public TN[] getORDERCALLBACKPHONENUM() {
        TN[] retVal = (TN[])this.getTypedField(17, new TN[0]);
        return retVal;
    }

    public TN[] getObr17_ORDERCALLBACKPHONENUM() {
        TN[] retVal = (TN[])this.getTypedField(17, new TN[0]);
        return retVal;
    }

    public int getORDERCALLBACKPHONENUMReps() {
        return this.getReps(17);
    }

    public TN getORDERCALLBACKPHONENUM(int rep) {
        TN retVal = (TN)this.getTypedField(17, rep);
        return retVal;
    }

    public TN getObr17_ORDERCALLBACKPHONENUM(int rep) {
        TN retVal = (TN)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObr17_ORDERCALLBACKPHONENUMReps() {
        return this.getReps(17);
    }

    public TN insertORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(17, rep);
    }

    public TN insertObr17_ORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(17, rep);
    }

    public TN removeORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(17, rep);
    }

    public TN removeObr17_ORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(17, rep);
    }

    public ST getPLACERSFIELD1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getObr18_PLACERSFIELD1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getPLACERSFIELD2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getObr19_PLACERSFIELD2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getFILLERSFIELD1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getObr20_FILLERSFIELD1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getFILLERSFIELD2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getObr21_FILLERSFIELD2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getRESULTSRPTSTATUSCHNGDATET() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getObr22_RESULTSRPTSTATUSCHNGDATET() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public CM getCHARGETOPRACTICE() {
        CM retVal = (CM)this.getTypedField(23, 0);
        return retVal;
    }

    public CM getObr23_CHARGETOPRACTICE() {
        CM retVal = (CM)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDIAGNOSTICSERVSECTID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getObr24_DIAGNOSTICSERVSECTID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getRESULTSTATUS() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getObr25_RESULTSTATUS() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getLINKEDRESULTS() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CE getObr26_LINKEDRESULTS() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CM[] getQUANTITYTIMING() {
        CM[] retVal = (CM[])this.getTypedField(27, new CM[0]);
        return retVal;
    }

    public CM[] getObr27_QUANTITYTIMING() {
        CM[] retVal = (CM[])this.getTypedField(27, new CM[0]);
        return retVal;
    }

    public int getQUANTITYTIMINGReps() {
        return this.getReps(27);
    }

    public CM getQUANTITYTIMING(int rep) {
        CM retVal = (CM)this.getTypedField(27, rep);
        return retVal;
    }

    public CM getObr27_QUANTITYTIMING(int rep) {
        CM retVal = (CM)this.getTypedField(27, rep);
        return retVal;
    }

    public int getObr27_QUANTITYTIMINGReps() {
        return this.getReps(27);
    }

    public CM insertQUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.insertRepetition(27, rep);
    }

    public CM insertObr27_QUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.insertRepetition(27, rep);
    }

    public CM removeQUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.removeRepetition(27, rep);
    }

    public CM removeObr27_QUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.removeRepetition(27, rep);
    }

    public CN[] getRESULTCOPIESTO() {
        CN[] retVal = (CN[])this.getTypedField(28, new CN[0]);
        return retVal;
    }

    public CN[] getObr28_RESULTCOPIESTO() {
        CN[] retVal = (CN[])this.getTypedField(28, new CN[0]);
        return retVal;
    }

    public int getRESULTCOPIESTOReps() {
        return this.getReps(28);
    }

    public CN getRESULTCOPIESTO(int rep) {
        CN retVal = (CN)this.getTypedField(28, rep);
        return retVal;
    }

    public CN getObr28_RESULTCOPIESTO(int rep) {
        CN retVal = (CN)this.getTypedField(28, rep);
        return retVal;
    }

    public int getObr28_RESULTCOPIESTOReps() {
        return this.getReps(28);
    }

    public CN insertRESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(28, rep);
    }

    public CN insertObr28_RESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(28, rep);
    }

    public CN removeRESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(28, rep);
    }

    public CN removeObr28_RESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(28, rep);
    }

    public CM getPARENTACCESSION() {
        CM retVal = (CM)this.getTypedField(29, 0);
        return retVal;
    }

    public CM getObr29_PARENTACCESSION() {
        CM retVal = (CM)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getTRANSPORTATIONMODE() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getObr30_TRANSPORTATIONMODE() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public CE[] getREASONFORSTUDY() {
        CE[] retVal = (CE[])this.getTypedField(31, new CE[0]);
        return retVal;
    }

    public CE[] getObr31_REASONFORSTUDY() {
        CE[] retVal = (CE[])this.getTypedField(31, new CE[0]);
        return retVal;
    }

    public int getREASONFORSTUDYReps() {
        return this.getReps(31);
    }

    public CE getREASONFORSTUDY(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public CE getObr31_REASONFORSTUDY(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public int getObr31_REASONFORSTUDYReps() {
        return this.getReps(31);
    }

    public CE insertREASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE insertObr31_REASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE removeREASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CE removeObr31_REASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CN getPRINCIPALRESULTINTERPRETER() {
        CN retVal = (CN)this.getTypedField(32, 0);
        return retVal;
    }

    public CN getObr32_PRINCIPALRESULTINTERPRETER() {
        CN retVal = (CN)this.getTypedField(32, 0);
        return retVal;
    }

    public CN getASSISTANTRESULTINTERPRETER() {
        CN retVal = (CN)this.getTypedField(33, 0);
        return retVal;
    }

    public CN getObr33_ASSISTANTRESULTINTERPRETER() {
        CN retVal = (CN)this.getTypedField(33, 0);
        return retVal;
    }

    public CN getTECHNICIAN() {
        CN retVal = (CN)this.getTypedField(34, 0);
        return retVal;
    }

    public CN getObr34_TECHNICIAN() {
        CN retVal = (CN)this.getTypedField(34, 0);
        return retVal;
    }

    public CN getTRANSCRIPTIONIST() {
        CN retVal = (CN)this.getTypedField(35, 0);
        return retVal;
    }

    public CN getObr35_TRANSCRIPTIONIST() {
        CN retVal = (CN)this.getTypedField(35, 0);
        return retVal;
    }

    public TS getSCHEDULEDDATETIME() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    public TS getObr36_SCHEDULEDDATETIME() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CM(this.getMessage());
            }
            case 2: {
                return new CM(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new CN(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new CM(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new CM(this.getMessage());
            }
            case 15: {
                return new CN(this.getMessage());
            }
            case 16: {
                return new TN(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new TS(this.getMessage());
            }
            case 22: {
                return new CM(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(74));
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(123));
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CM(this.getMessage());
            }
            case 27: {
                return new CN(this.getMessage());
            }
            case 28: {
                return new CM(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(124));
            }
            case 30: {
                return new CE(this.getMessage());
            }
            case 31: {
                return new CN(this.getMessage());
            }
            case 32: {
                return new CN(this.getMessage());
            }
            case 33: {
                return new CN(this.getMessage());
            }
            case 34: {
                return new CN(this.getMessage());
            }
            case 35: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

