/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import io.netty.channel.ChannelHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;

public class PipelineHandlerBuilderUtil {
    private static final Log log = LogFactory.getLog(PipelineHandlerBuilderUtil.class);

    public static ChannelHandler stringToPipelineHandlers(String handlerClass) {
        ChannelHandler hand = null;
        if (handlerClass != null) {
            try {
                Class<?> c = Class.forName(handlerClass);
                Constructor<?> cons = c.getConstructor(new Class[0]);
                ChannelHandler handlerInstance = (ChannelHandler)cons.newInstance(new Object[0]);
                return handlerInstance;
            }
            catch (ClassNotFoundException e) {
                String msg = "Class " + handlerClass + " not found. Please check the required class is added to the classpath.";
                log.error((Object)msg, (Throwable)e);
                throw new SynapseException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                String msg = "Required constructor is not implemented.";
                log.error((Object)msg, (Throwable)e);
                throw new SynapseException((Throwable)e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                String msg = "Couldn't create the class instance.";
                log.error((Object)msg, (Throwable)e);
                throw new SynapseException((Throwable)e);
            }
        }
        return hand;
    }
}

