/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;

public class InboundWebsocketChannelContext {
    private ChannelHandlerContext ctx;
    private String channelIdentifier;

    public InboundWebsocketChannelContext(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.channelIdentifier = ctx.channel().toString();
    }

    public void writeToChannel(WebSocketFrame frame) {
        if (this.ctx.channel().isActive()) {
            this.ctx.channel().writeAndFlush((Object)frame.retain());
        }
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.ctx;
    }

    public String getChannelIdentifier() {
        return this.channelIdentifier;
    }

    public void addCloseListener(final ChannelHandlerContext targetCtx) {
        ChannelFuture closeFuture = this.ctx.channel().closeFuture();
        closeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess() && targetCtx.channel().isActive()) {
                    targetCtx.channel().write((Object)new CloseWebSocketFrame()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
        });
    }
}

