/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.mqtt;

import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.InboundOneTimeTriggerRequestProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttAsyncCallback;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttClientManager;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionFactory;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttTask;

public class MqttListener
extends InboundOneTimeTriggerRequestProcessor {
    private static final String ENDPOINT_POSTFIX = "MQTT--SYNAPSE_INBOUND_ENDPOINT";
    private static final Log log = LogFactory.getLog(MqttListener.class);
    private String injectingSeq;
    private String onErrorSeq;
    private Properties mqttProperties;
    private String contentType;
    private boolean sequential;
    private MqttConnectionFactory confac;
    private MqttAsyncClient mqttAsyncClient;
    private MqttAsyncCallback mqttAsyncCallback;
    private MqttConnectOptions connectOptions;
    private MqttConnectionConsumer connectionConsumer;
    private MqttInjectHandler injectHandler;
    protected String userName;
    protected String password;
    protected boolean cleanSession;
    private InboundProcessorParams params;
    private SSLSocketFactory socketFactory;

    public MqttListener(InboundProcessorParams params) {
        this.name = params.getName();
        this.injectingSeq = params.getInjectingSeq();
        this.onErrorSeq = params.getOnErrorSeq();
        this.synapseEnvironment = params.getSynapseEnvironment();
        this.mqttProperties = params.getProperties();
        this.params = params;
        this.sequential = true;
        if (this.mqttProperties.getProperty("sequential") != null) {
            this.sequential = Boolean.parseBoolean(this.mqttProperties.getProperty("sequential"));
        }
        this.coordination = true;
        if (this.mqttProperties.getProperty("coordination") != null) {
            this.coordination = Boolean.parseBoolean(this.mqttProperties.getProperty("coordination"));
        }
        this.confac = new MqttConnectionFactory(this.mqttProperties);
        this.contentType = this.confac.getContent();
        this.injectHandler = new MqttInjectHandler(this.injectingSeq, this.onErrorSeq, this.sequential, this.synapseEnvironment, this.contentType);
        this.synapseEnvironment = params.getSynapseEnvironment();
        this.socketFactory = this.confac.getSSLSocketFactory();
        if (this.mqttProperties.getProperty("mqtt.subscription.username") != null) {
            this.userName = this.mqttProperties.getProperty("mqtt.subscription.username");
        }
        if (this.mqttProperties.getProperty("mqtt.subscription.password") != null) {
            this.password = this.mqttProperties.getProperty("mqtt.subscription.password");
        }
        if (this.mqttProperties.getProperty("mqtt.session.clean") != null) {
            this.cleanSession = Boolean.parseBoolean(this.mqttProperties.getProperty("mqtt.session.clean"));
        }
    }

    @Override
    public void destroy() {
        log.info((Object)("Mqtt Inbound endpoint: " + this.name + " Started destroying context."));
        MqttClientManager clientManager = MqttClientManager.getInstance();
        String inboundIdentifier = clientManager.buildIdentifier(this.mqttAsyncClient.getClientId(), this.confac.getServerHost(), this.confac.getServerPort());
        if (!clientManager.isInboundTenantLoadingFlagSet(inboundIdentifier)) {
            this.connectionConsumer.shutdown();
            this.mqttAsyncCallback.shutdown();
            this.confac.shutdown(this.mqttAsyncClient.isConnected());
            try {
                if (this.mqttAsyncClient.isConnected()) {
                    this.mqttAsyncClient.unsubscribe(this.confac.getTopic());
                    this.mqttAsyncClient.disconnect();
                }
                this.mqttAsyncClient.close();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                int tenantId = carbonContext.getTenantId();
                String nameIdentifier = clientManager.buildNameIdentifier(this.name, String.valueOf(tenantId));
                MqttClientManager.getInstance().unregisterMqttClient(inboundIdentifier, nameIdentifier);
                log.info((Object)"Disconnected from the remote MQTT server.");
            }
            catch (MqttException e) {
                log.error((Object)"Error while disconnecting from the remote server.");
            }
        }
        super.destroy();
    }

    public void init() {
        log.info((Object)("MQTT inbound endpoint " + this.name + " initializing ..."));
        this.initAsyncClient();
        this.start();
    }

    public void initAsyncClient() {
        String inboundIdentifier;
        this.mqttAsyncClient = this.confac.getMqttAsyncClient(this.name);
        MqttClientManager clientManager = MqttClientManager.getInstance();
        if (!clientManager.hasMqttCallback(inboundIdentifier = clientManager.buildIdentifier(this.mqttAsyncClient.getClientId(), this.confac.getServerHost(), this.confac.getServerPort()))) {
            this.connectOptions = new MqttConnectOptions();
            this.connectOptions.setCleanSession(this.cleanSession);
            if (this.userName != null && this.password != null) {
                this.connectOptions.setUserName(this.userName);
                this.connectOptions.setPassword(this.password.toCharArray());
            }
            if (this.socketFactory != null) {
                this.connectOptions.setSocketFactory((SocketFactory)this.socketFactory);
            }
            this.mqttAsyncCallback = new MqttAsyncCallback(this.mqttAsyncClient, this.injectHandler, this.confac, this.connectOptions, this.mqttProperties);
            this.mqttAsyncCallback.setName(this.params.getName());
            this.connectionConsumer = new MqttConnectionConsumer(this.connectOptions, this.mqttAsyncClient, this.confac, this.mqttProperties, this.name);
            this.mqttAsyncCallback.setMqttConnectionConsumer(this.connectionConsumer);
            this.mqttAsyncClient.setCallback((MqttCallback)this.mqttAsyncCallback);
            clientManager.registerMqttCallback(inboundIdentifier, this.mqttAsyncCallback);
        } else {
            clientManager.unRegisterInboundTenantLoadingFlag(inboundIdentifier);
            this.mqttAsyncCallback = clientManager.getMqttCallback(inboundIdentifier);
            this.mqttAsyncCallback.setName(this.params.getName());
            this.connectOptions = this.mqttAsyncCallback.getMqttConnectionOptions();
            this.connectionConsumer = this.mqttAsyncCallback.getMqttConnectionConsumer();
            this.mqttAsyncCallback.updateInjectHandler(this.injectHandler);
        }
    }

    public void start() {
        MqttTask mqttTask = new MqttTask(this.connectionConsumer);
        mqttTask.setCallback(this.mqttAsyncCallback);
        this.start(mqttTask, ENDPOINT_POSTFIX);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

