/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.mqtt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttInjectHandler {
    private static final Log log = LogFactory.getLog(MqttInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private String contentType;
    private SynapseEnvironment synapseEnvironment;

    public MqttInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment, String contentType) {
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
        this.contentType = contentType;
    }

    public boolean invoke(MqttMessage mqttMessage, String name, String topicName) {
        try {
            org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
            msgCtx.setProperty("mqtt.topic.name", (Object)topicName);
            msgCtx.setProperty("isInbound", (Object)true);
            if (name != null) {
                InboundEndpoint inboundEndpoint = msgCtx.getConfiguration().getInboundEndpoint(name);
                CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
            }
            String message = mqttMessage.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed MQTT Message of Content-type : " + this.contentType));
            }
            MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
            SOAPBuilder builder = null;
            if (this.contentType == null) {
                log.debug((Object)"No content type specified. Using SOAP builder.");
                builder = new SOAPBuilder();
            } else {
                int index = this.contentType.indexOf(59);
                String type = index > 0 ? this.contentType.substring(0, index) : this.contentType;
                try {
                    builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error while creating message builder :: " + axisFault.getMessage()));
                }
                if (builder == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                    }
                    builder = new SOAPBuilder();
                }
            }
            OMElement documentElement = null;
            AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(message.getBytes()));
            documentElement = builder.processDocument((InputStream)in, this.contentType, axis2MsgCtx);
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
            if (this.injectingSeq == null || "".equals(this.injectingSeq)) {
                log.error((Object)("Sequence name not specified. Sequence : " + this.injectingSeq));
                return false;
            }
            SequenceMediator seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.injectingSeq);
            if (seq != null) {
                if (!seq.isInitialized()) {
                    seq.init(this.synapseEnvironment);
                }
                seq.setErrorHandler(this.onErrorSeq);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
                }
                if (!this.synapseEnvironment.injectInbound(msgCtx, seq, this.sequential)) {
                    return false;
                }
            } else {
                log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while processing the MQTT Message");
        }
        return true;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUIDGenerator.getUUID());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        return msgCtx;
    }
}

