/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.kafka;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.cluster.Broker;
import kafka.common.ErrorMapping;
import kafka.common.TopicAndPartition;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.TopicMetadataResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.message.MessageAndOffset;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.AbstractKafkaMessageListener;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.InjectHandler;

public class SimpleKafkaMessageListener
extends AbstractKafkaMessageListener {
    private List<String> replicaBrokers;
    private boolean init;
    private String topic;
    private long maxReads = Long.MAX_VALUE;
    private int partition;
    private List<String> seedBrokers;
    private int port;
    private String leadBroker;
    private String clientName;
    private SimpleConsumer consumer;
    private long readOffset;

    public SimpleKafkaMessageListener(Properties kafkaProperties, InjectHandler injectHandler) throws Exception {
        this.kafkaProperties = kafkaProperties;
        this.injectHandler = injectHandler;
        this.replicaBrokers = new ArrayList<String>();
        this.validateInputParameters();
    }

    private void validateInputParameters() throws Exception {
        if (this.kafkaProperties.getProperty("simple.topic") == null) {
            log.error((Object)"simple consumer topic is invalid");
            throw new SynapseException("simple consumer topic is invalid");
        }
        this.topic = this.kafkaProperties.getProperty("simple.topic");
        if (this.kafkaProperties.getProperty("simple.brokers") == null) {
            log.error((Object)"simple consumer brokers is invalid");
            throw new SynapseException("simple consumer brokers is invalid");
        }
        this.seedBrokers = this.getSeedBrokers(this.kafkaProperties.getProperty("simple.brokers"));
        if (this.kafkaProperties.getProperty("simple.port") == null) {
            log.error((Object)"simple consumer port is invalid");
            throw new SynapseException("simple consumer port is invalid");
        }
        try {
            this.port = Integer.parseInt(this.kafkaProperties.getProperty("simple.port"));
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("simple consumer port should be number." + nfe.getMessage()), (Throwable)nfe);
            throw new SynapseException("simple consumer port should be number.", (Throwable)nfe);
        }
        if (this.kafkaProperties.getProperty("simple.partition") == null) {
            log.error((Object)"simple consumer partition is invalid");
            throw new SynapseException("simple consumer partition is invalid");
        }
        try {
            this.partition = Integer.parseInt(this.kafkaProperties.getProperty("simple.partition"));
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("simple partition should be a number " + nfe.getMessage()), (Throwable)nfe);
            throw new SynapseException("simple partition should be a number", (Throwable)nfe);
        }
        if (this.kafkaProperties.getProperty("simple.max.messages.to.read") == null) {
            log.error((Object)"simple consumer maximum messages to read is invalid");
            throw new SynapseException("simple consumer maximum messages to read is invalid");
        }
        try {
            this.maxReads = Long.parseLong(this.kafkaProperties.getProperty("simple.max.messages.to.read"));
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("maximum messages should be a number " + nfe.getMessage()), (Throwable)nfe);
            throw new SynapseException("maximum messages should be a number", (Throwable)nfe);
        }
    }

    private List<String> getSeedBrokers(String brokers) {
        try {
            return Arrays.asList(brokers.split(","));
        }
        catch (Exception nfe) {
            log.error((Object)("Error to split the brokers from broker list" + nfe.getMessage()), (Throwable)nfe);
            throw new SynapseException("Error to split the brokers from broker list", (Throwable)nfe);
        }
    }

    @Override
    public boolean createKafkaConsumerConnector() throws Exception {
        return this.run();
    }

    @Override
    public void start() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectMessageToESB(String name) {
        log.debug((Object)"Fetch the messages until maximum message is zero");
        if (this.maxReads > 0L) {
            FetchRequest req;
            FetchResponse fetchResponse;
            if (this.consumer == null) {
                this.consumer = new SimpleConsumer(this.leadBroker, this.port, 100000, 65536, this.clientName);
            }
            if ((fetchResponse = this.consumer.fetch(req = new FetchRequestBuilder().clientId(this.clientName).addFetch(this.topic, this.partition, this.readOffset, 100000).build())).hasError()) {
                short code = fetchResponse.errorCode(this.topic, this.partition);
                log.error((Object)("Error fetching data from the Broker:" + this.leadBroker + " Reason: " + code));
                if (code == ErrorMapping.OffsetOutOfRangeCode()) {
                    this.readOffset = SimpleKafkaMessageListener.getLastOffset(this.consumer, this.topic, this.partition, kafka.api.OffsetRequest.LatestTime(), this.clientName);
                }
                this.consumer.close();
                this.consumer = null;
                try {
                    this.leadBroker = this.findNewLeader(this.leadBroker, this.topic, this.partition, this.port);
                }
                catch (Exception e) {
                    log.error((Object)("Error to find the new leader " + e.getMessage()), (Throwable)e);
                }
            }
            try {
                for (MessageAndOffset messageAndOffset : fetchResponse.messageSet(this.topic, this.partition)) {
                    long currentOffset = messageAndOffset.offset();
                    if (currentOffset < this.readOffset) {
                        log.info((Object)("Found an old offset: " + currentOffset + " Expecting: " + this.readOffset));
                        continue;
                    }
                    this.readOffset = messageAndOffset.nextOffset();
                    ByteBuffer payload = messageAndOffset.message().payload();
                    byte[] bytes = new byte[payload.limit()];
                    payload.get(bytes);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Start : Add to injectHandler to invoke");
                        }
                        this.injectHandler.invoke(bytes, name);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"End : Add the injectHandler to invoke");
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while invoking the bytes " + e.getMessage()), (Throwable)e);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"0 - added to queue!");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Reduce the maximum message by 1");
                    }
                    --this.maxReads;
                    if (this.maxReads >= 1L) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while fetching the responses" + e.getMessage()), (Throwable)e);
                log.debug((Object)"Error to fetch the responses");
            }
            finally {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.maxReads == Long.MAX_VALUE) {
            return true;
        }
        return this.maxReads > 0L;
    }

    public boolean run() throws Exception {
        if (this.init) {
            return this.init;
        }
        PartitionMetadata metadata = this.findLeader(this.seedBrokers, this.port, this.topic, this.partition);
        if (metadata == null) {
            throw new SynapseException("Can't find metadata for Topic and Partition. Exiting");
        }
        if (metadata.leader() == null) {
            throw new SynapseException("Can't find Leader for Topic and Partition. Exiting");
        }
        this.leadBroker = metadata.leader().host();
        this.clientName = "Client_" + this.topic + "_" + this.partition;
        this.consumer = new SimpleConsumer(this.leadBroker, this.port, 65536, 100000, this.clientName);
        this.readOffset = SimpleKafkaMessageListener.getLastOffset(this.consumer, this.topic, this.partition, kafka.api.OffsetRequest.EarliestTime(), this.clientName);
        this.init = true;
        return this.init;
    }

    public static long getLastOffset(SimpleConsumer consumer, String topic, int partition, long whichTime, String clientName) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        HashMap<TopicAndPartition, PartitionOffsetRequestInfo> requestInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
        requestInfo.put(topicAndPartition, new PartitionOffsetRequestInfo(whichTime, 1));
        OffsetRequest request = new OffsetRequest(requestInfo, kafka.api.OffsetRequest.CurrentVersion(), clientName);
        OffsetResponse response = consumer.getOffsetsBefore(request);
        if (response.hasError()) {
            log.error((Object)("Error fetching data Offset Data the Broker. Reason: " + response.errorCode(topic, partition)));
            return 0L;
        }
        long[] offsets = response.offsets(topic, partition);
        return offsets[0];
    }

    private String findNewLeader(String oldLeader, String topic, int partition, int port) throws Exception {
        for (int i = 0; i < 3; ++i) {
            boolean goToSleep = false;
            PartitionMetadata metadata = this.findLeader(this.replicaBrokers, port, topic, partition);
            if (metadata == null) {
                goToSleep = true;
            } else if (metadata.leader() == null) {
                goToSleep = true;
            } else if (oldLeader.equalsIgnoreCase(metadata.leader().host()) && i == 0) {
                goToSleep = true;
            } else {
                return metadata.leader().host();
            }
            if (!goToSleep) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new SynapseException("Unable to find new leader after Broker failure. Exiting");
    }

    private PartitionMetadata findLeader(List<String> a_seedBrokers, int port, String topic, int partition) throws Exception {
        PartitionMetadata returnMetaData = null;
        block6: for (String seed : a_seedBrokers) {
            SimpleConsumer consumer = null;
            try {
                consumer = new SimpleConsumer(seed, port, 100000, 65536, "leaderLookup");
                List<String> topics = Collections.singletonList(topic);
                TopicMetadataRequest req = new TopicMetadataRequest(topics);
                TopicMetadataResponse resp = consumer.send(req);
                List metaData = resp.topicsMetadata();
                for (TopicMetadata item : metaData) {
                    for (PartitionMetadata part : item.partitionsMetadata()) {
                        if (part.partitionId() != partition) continue;
                        returnMetaData = part;
                        break block6;
                    }
                }
            }
            catch (Exception e) {
                throw new SynapseException("Error communicating with Broker [" + seed + "] to find Leader for [" + topic + ", " + partition + "] Reason: ", (Throwable)e);
            }
            finally {
                if (consumer == null) continue;
                consumer.close();
            }
        }
        if (returnMetaData != null) {
            this.replicaBrokers.clear();
            for (Broker replica : returnMetaData.replicas()) {
                this.replicaBrokers.add(replica.host());
            }
        }
        return returnMetaData;
    }
}

