/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.jms.factory;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSConstants;
import org.wso2.carbon.inbound.endpoint.protocol.jms.factory.JMSConnectionFactory;

public class CachedJMSConnectionFactory
extends JMSConnectionFactory {
    private static final Log logger = LogFactory.getLog(CachedJMSConnectionFactory.class);
    private int cacheLevel = 0;
    private Connection cachedConnection = null;
    private Session cachedSession = null;
    private MessageConsumer cachedMessageConsumer = null;

    public CachedJMSConnectionFactory(Properties properties) {
        super(properties);
        this.setValues(properties);
    }

    public CachedJMSConnectionFactory(Properties properties, Connection cachedConnection) {
        super(properties);
        this.cachedConnection = cachedConnection;
        this.setValues(properties);
    }

    private void setValues(Properties properties) {
        String cacheLevel = properties.getProperty("transport.jms.CacheLevel");
        this.cacheLevel = null != cacheLevel && !"".equals(cacheLevel) ? Integer.parseInt(cacheLevel) : 0;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return super.getConnectionFactory();
    }

    public Connection getConnection(String userName, String password) {
        Connection connection = this.cachedConnection == null ? this.createConnection(userName, password) : this.cachedConnection;
        if (connection == null) {
            return null;
        }
        try {
            connection.start();
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while starting connection for factory '" + this.connectionFactoryString + "' "), (Throwable)e);
            this.resetCache();
            return null;
        }
        return connection;
    }

    @Override
    public Connection createConnection(String userName, String password) {
        Connection connection = userName == null || password == null ? super.createConnection() : super.createConnection(userName, password);
        if (this.cacheLevel >= 1) {
            this.cachedConnection = connection;
        }
        return connection;
    }

    @Override
    public Session getSession(Connection connection) {
        if (this.cachedSession == null) {
            return this.createSession(connection);
        }
        return this.cachedSession;
    }

    @Override
    protected Session createSession(Connection connection) {
        Session session = super.createSession(connection);
        if (this.cacheLevel >= 2) {
            this.cachedSession = session;
        }
        return session;
    }

    public MessageConsumer getMessageConsumer(Session session, Destination destination) {
        MessageConsumer messageConsumer = null;
        messageConsumer = this.cachedMessageConsumer == null ? this.createMessageConsumer(session, destination) : this.cachedMessageConsumer;
        return messageConsumer;
    }

    @Override
    public MessageConsumer createMessageConsumer(Session session, Destination destination) {
        MessageConsumer messageConsumer = super.createMessageConsumer(session, destination);
        if (this.cacheLevel >= 3) {
            this.cachedMessageConsumer = messageConsumer;
        }
        return messageConsumer;
    }

    @Override
    public MessageProducer createProducer(Session session, Destination destination, Boolean isQueue) throws JMSException {
        return super.createProducer(session, destination, isQueue);
    }

    public boolean closeConnection() {
        try {
            if (this.cachedConnection != null) {
                this.cachedConnection.close();
                this.cachedConnection = null;
            }
            return true;
        }
        catch (JMSException e) {
            logger.error((Object)"JMS Exception while closing the connection.", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean closeConnection(Connection connection) {
        return this.closeConnection(connection, false);
    }

    public boolean closeConsumer(MessageConsumer messageConsumer) {
        return this.closeConsumer(messageConsumer, false);
    }

    public boolean closeSession(Session session) {
        return this.closeSession(session, false);
    }

    public boolean closeConnection(Connection connection, boolean forcefully) {
        try {
            if (this.cacheLevel < 1 || forcefully) {
                connection.close();
                this.cachedConnection = null;
            }
        }
        catch (JMSException e) {
            logger.error((Object)"JMS Exception while closing the connection.", (Throwable)e);
        }
        return false;
    }

    public boolean closeConsumer(MessageConsumer messageConsumer, boolean forcefully) {
        try {
            if (this.cacheLevel < 3 || forcefully) {
                messageConsumer.close();
                this.cachedMessageConsumer = null;
            }
        }
        catch (JMSException e) {
            logger.error((Object)"JMS Exception while closing the consumer.", (Throwable)e);
        }
        return false;
    }

    public boolean closeSession(Session session, boolean forcefully) {
        try {
            if (this.cacheLevel < 2 || forcefully) {
                session.close();
                this.cachedSession = null;
            }
        }
        catch (JMSException e) {
            logger.error((Object)"JMS Exception while closing the consumer.", (Throwable)e);
        }
        return false;
    }

    private void resetCache() {
        if (this.cachedConnection != null) {
            try {
                this.cachedConnection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.cachedConnection = null;
        }
        if (this.cachedSession != null) {
            try {
                this.cachedSession.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.cachedSession = null;
        }
        if (this.cachedMessageConsumer != null) {
            try {
                this.cachedMessageConsumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.cachedMessageConsumer = null;
        }
    }

    @Override
    public JMSConstants.JMSDestinationType getDestinationType() {
        return this.destinationType;
    }
}

