/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.https;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;
import org.wso2.carbon.inbound.endpoint.protocol.http.InboundHttpListener;
import org.wso2.carbon.inbound.endpoint.protocol.http.management.HTTPEndpointManager;

public class InboundHttpsListener
extends InboundHttpListener {
    private static final Log log = LogFactory.getLog(InboundHttpListener.class);
    private SSLConfiguration sslConfiguration;
    private int port;
    private String name;
    private InboundProcessorParams processorParams;

    public InboundHttpsListener(InboundProcessorParams params) {
        super(params);
        this.processorParams = params;
        String portParam = params.getProperties().getProperty("inbound.http.port");
        try {
            this.port = Integer.parseInt(portParam);
        }
        catch (NumberFormatException e) {
            this.handleException("Please provide port number as integer  instead of  port  " + portParam, e);
        }
        this.name = params.getName();
        String keyStoreParam = params.getProperties().getProperty("keystore");
        String trustStoreParam = params.getProperties().getProperty("truststore");
        String clientAuthParam = params.getProperties().getProperty("SSLVerifyClient");
        String sslProtocol = params.getProperties().getProperty("SSLProtocol");
        String httpsProtocols = params.getProperties().getProperty("HttpsProtocols");
        String certificateRevocation = params.getProperties().getProperty("CertificateRevocationVerifier");
        String preferredCiphers = params.getProperties().getProperty("PreferredCiphers");
        this.sslConfiguration = new SSLConfiguration(keyStoreParam, trustStoreParam, clientAuthParam, httpsProtocols, certificateRevocation, sslProtocol, preferredCiphers);
    }

    @Override
    public void init() {
        if (this.isPortUsedByAnotherApplication(this.port)) {
            log.warn((Object)("Port " + this.port + "used by inbound endpoint " + this.name + " is already used by another application hence undeploying inbound endpoint"));
            throw new SynapseException("Port " + this.port + " used by inbound endpoint " + this.name + " is already used by another application.");
        }
        HTTPEndpointManager.getInstance().startSSLEndpoint(this.port, this.name, this.sslConfiguration, this.processorParams);
    }
}

