/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.http.management;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.transport.passthru.api.PassThroughInboundEndpointHandler;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.AbstractInboundEndpointManager;
import org.wso2.carbon.inbound.endpoint.internal.http.api.ConfigurationLoader;
import org.wso2.carbon.inbound.endpoint.internal.http.api.InternalAPI;
import org.wso2.carbon.inbound.endpoint.internal.http.api.InternalAPIDispatcher;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointInfoDTO;
import org.wso2.carbon.inbound.endpoint.protocol.http.InboundHttpConfiguration;
import org.wso2.carbon.inbound.endpoint.protocol.http.InboundHttpSourceHandler;
import org.wso2.carbon.inbound.endpoint.protocol.http.config.WorkerPoolConfiguration;

public class HTTPEndpointManager
extends AbstractInboundEndpointManager {
    private static HTTPEndpointManager instance = new HTTPEndpointManager();
    private static final Log log = LogFactory.getLog(HTTPEndpointManager.class);
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, WorkerPoolConfiguration>> workerPoolMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, Pattern>> dispatchPatternMap = new ConcurrentHashMap();
    private int internalInboundHttpPort;
    private int internalInboundHttpsPort;
    private InternalAPIDispatcher internalHttpApiDispatcher;
    private InternalAPIDispatcher internalHttpsApiDispatcher;
    private boolean internalHttpApiEnabled;
    private boolean internalHttpsApiEnabled;

    private HTTPEndpointManager() {
        if (ConfigurationLoader.isInternalApiEnabled()) {
            this.internalInboundHttpPort = ConfigurationLoader.getInternalInboundHttpPort();
            this.internalInboundHttpsPort = ConfigurationLoader.getInternalInboundHttpsPort();
            ConfigurationLoader.loadInternalApis("internal-apis.xml");
            List<InternalAPI> httpInternalAPIList = ConfigurationLoader.getHttpInternalApis();
            this.internalHttpApiDispatcher = new InternalAPIDispatcher(httpInternalAPIList);
            this.internalHttpApiEnabled = !httpInternalAPIList.isEmpty();
            List<InternalAPI> httpsInternalAPIList = ConfigurationLoader.getHttpsInternalApis();
            this.internalHttpsApiDispatcher = new InternalAPIDispatcher(httpsInternalAPIList);
            this.internalHttpsApiEnabled = !httpsInternalAPIList.isEmpty();
        }
    }

    public static HTTPEndpointManager getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean startEndpoint(int port, String name, InboundProcessorParams params) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        InboundHttpConfiguration config = this.buildConfiguration(port, name, params);
        String epName = this.dataStore.getListeningEndpointName(port, tenantDomain);
        if (epName != null) {
            if (epName.equalsIgnoreCase(name)) {
                this.applyConfiguration(config, tenantDomain, port);
                log.info((Object)(epName + " Endpoint is already started in port : " + port));
                return true;
            }
            String msg = "Another endpoint named : " + epName + " is currently using this port: " + port;
            log.warn((Object)msg);
            throw new SynapseException(msg);
        }
        this.dataStore.registerListeningEndpoint(port, tenantDomain, "http", name, params);
        boolean start = this.startListener(port, name, params);
        if (start) {
            this.applyConfiguration(config, tenantDomain, port);
            return true;
        }
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean startSSLEndpoint(int port, String name, SSLConfiguration sslConfiguration, InboundProcessorParams params) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        InboundHttpConfiguration config = this.buildConfiguration(port, name, params);
        String epName = this.dataStore.getListeningEndpointName(port, tenantDomain);
        if (PassThroughInboundEndpointHandler.isEndpointRunning((int)port)) {
            if (epName != null && epName.equalsIgnoreCase(name)) {
                this.applyConfiguration(config, tenantDomain, port);
                log.info((Object)(epName + " Endpoint is already started in port : " + port));
                return true;
            }
            String msg = "Cannot Start Endpoint " + name + " Already occupied port " + port + " by another Endpoint ";
            log.warn((Object)msg);
            throw new SynapseException(msg);
        }
        if (epName != null && epName.equalsIgnoreCase(name)) {
            log.info((Object)(epName + " Endpoint is already registered in registry"));
        } else {
            this.dataStore.registerSSLListeningEndpoint(port, tenantDomain, "https", name, sslConfiguration, params);
        }
        boolean start = this.startSSLListener(port, name, sslConfiguration, params);
        if (start) {
            this.applyConfiguration(config, tenantDomain, port);
            return true;
        }
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        return false;
    }

    private void applyConfiguration(InboundHttpConfiguration config, String tenantDomain, int port) {
        if (config.getCoresize() != null && config.getMaxSize() != null && config.getKeepAlive() != null && config.getQueueLength() != null) {
            WorkerPoolConfiguration workerPoolConfiguration = new WorkerPoolConfiguration(config.getCoresize(), config.getMaxSize(), config.getKeepAlive(), config.getQueueLength(), config.getThreadGroup(), config.getThreadID());
            this.addWorkerPool(tenantDomain, port, workerPoolConfiguration);
        }
        if (config.getDispatchPattern() != null) {
            Pattern pattern = this.compilePattern(config.getDispatchPattern());
            this.addDispatchPattern(tenantDomain, port, pattern);
        }
    }

    @Override
    public boolean startListener(int port, String name, InboundProcessorParams params) {
        if (PassThroughInboundEndpointHandler.isEndpointRunning((int)port)) {
            log.info((Object)("Listener is already started for port : " + port));
            return true;
        }
        SourceConfiguration sourceConfiguration = null;
        try {
            sourceConfiguration = PassThroughInboundEndpointHandler.getPassThroughSourceConfiguration();
        }
        catch (Exception e) {
            log.warn((Object)"Cannot get PassThroughSourceConfiguration ", (Throwable)e);
            return false;
        }
        if (sourceConfiguration != null) {
            InboundHttpSourceHandler inboundSourceHandler = new InboundHttpSourceHandler(port, sourceConfiguration);
            try {
                PassThroughInboundEndpointHandler.startEndpoint((InetSocketAddress)new InetSocketAddress(port), (NHttpServerEventHandler)inboundSourceHandler, (String)name);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Exception occurred while starting listener for endpoint : " + name + " ,port " + port), (Throwable)e);
            }
        } else {
            log.warn((Object)("SourceConfiguration is not registered in PassThrough Transport hence not start inbound endpoint " + name));
            return false;
        }
        return true;
    }

    public boolean startSSLListener(int port, String name, SSLConfiguration sslConfiguration, InboundProcessorParams params) {
        if (PassThroughInboundEndpointHandler.isEndpointRunning((int)port)) {
            log.info((Object)("Listener is already started for port : " + port));
            return true;
        }
        SourceConfiguration sourceConfiguration = null;
        try {
            sourceConfiguration = PassThroughInboundEndpointHandler.getPassThroughSSLSourceConfiguration();
        }
        catch (Exception e) {
            log.warn((Object)"Cannot get PassThroughSSLSourceConfiguration ", (Throwable)e);
            return false;
        }
        if (sourceConfiguration != null) {
            InboundHttpSourceHandler inboundSourceHandler = new InboundHttpSourceHandler(port, sourceConfiguration);
            try {
                PassThroughInboundEndpointHandler.startSSLEndpoint((InetSocketAddress)new InetSocketAddress(port), (NHttpServerEventHandler)inboundSourceHandler, (String)name, (SSLConfiguration)sslConfiguration);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Exception occurred while starting listener for endpoint : " + name + " ,port " + port), (Throwable)e);
                return false;
            }
        } else {
            log.warn((Object)("SourceConfiguration is not registered in PassThrough Transport hence not start inbound endpoint " + name));
            return false;
        }
        return true;
    }

    @Override
    public void closeEndpoint(int port) {
        PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = cc.getTenantDomain();
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        this.removeWorkerPoolConfiguration(tenantDomain, port);
        this.removeDispatchPattern(tenantDomain, port);
        if (!PassThroughInboundEndpointHandler.isEndpointRunning((int)port)) {
            log.info((Object)"Listener Endpoint is not started");
            return;
        }
        if (this.dataStore.isEndpointRegistryEmpty(port)) {
            PassThroughInboundEndpointHandler.closeEndpoint((int)port);
        }
    }

    public InboundHttpConfiguration buildConfiguration(int port, String name, InboundProcessorParams params) {
        return new InboundHttpConfiguration.InboundHttpConfigurationBuilder(port, name).workerPoolCoreSize(params.getProperties().getProperty("inbound.worker.pool.size.core")).workerPoolMaxSize(params.getProperties().getProperty("inbound.worker.pool.size.max")).workerPoolKeepAlive(params.getProperties().getProperty("inbound.worker.thread.keep.alive.sec")).workerPoolQueueLength(params.getProperties().getProperty("inbound.worker.pool.queue.length")).workerPoolThreadGroup(params.getProperties().getProperty("inbound.thread.group.id")).workerPoolThreadId(params.getProperties().getProperty("inbound.thread.id")).dispatchPattern(params.getProperties().getProperty("dispatch.filter.pattern")).build();
    }

    public void loadEndpointListeners() {
        Map tenantData = this.dataStore.getAllListeningEndpointData();
        for (Map.Entry tenantInfoEntry : tenantData.entrySet()) {
            int port = (Integer)tenantInfoEntry.getKey();
            InboundEndpointInfoDTO inboundEndpointInfoDTO = (InboundEndpointInfoDTO)((ArrayList)tenantInfoEntry.getValue()).get(0);
            if (inboundEndpointInfoDTO.getProtocol().equals("http")) {
                this.startListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getInboundParams());
                continue;
            }
            if (!inboundEndpointInfoDTO.getProtocol().equals("https")) continue;
            this.startSSLListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getSslConfiguration(), inboundEndpointInfoDTO.getInboundParams());
        }
    }

    public void addWorkerPool(String tenantDomain, int port, WorkerPoolConfiguration workerPoolConfiguration) {
        ConcurrentHashMap<Integer, WorkerPoolConfiguration> concurrentHashMap = this.workerPoolMap.get(tenantDomain);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap();
            concurrentHashMap.put(port, workerPoolConfiguration);
            this.workerPoolMap.put(tenantDomain, concurrentHashMap);
        } else {
            concurrentHashMap.put(port, workerPoolConfiguration);
        }
    }

    public WorkerPoolConfiguration getWorkerPoolConfiguration(String tenantDomain, int port) {
        WorkerPoolConfiguration val;
        ConcurrentHashMap<Integer, WorkerPoolConfiguration> concurrentHashMap = this.workerPoolMap.get(tenantDomain);
        if (concurrentHashMap != null && (val = concurrentHashMap.get(port)) instanceof WorkerPoolConfiguration) {
            return val;
        }
        return null;
    }

    public void removeWorkerPoolConfiguration(String tenantDomian, int port) {
        ConcurrentHashMap<Integer, WorkerPoolConfiguration> concurrentHashMap = this.workerPoolMap.get(tenantDomian);
        if (concurrentHashMap != null && concurrentHashMap.containsKey(port)) {
            concurrentHashMap.remove(port);
        }
    }

    public void addDispatchPattern(String tenantDomain, int port, Pattern pattern) {
        ConcurrentHashMap<Integer, Pattern> concurrentHashMap = this.dispatchPatternMap.get(tenantDomain);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap();
            concurrentHashMap.put(port, pattern);
            this.dispatchPatternMap.put(tenantDomain, concurrentHashMap);
        } else {
            concurrentHashMap.put(port, pattern);
        }
    }

    public void removeDispatchPattern(String tenantDomain, int port) {
        ConcurrentHashMap<Integer, Pattern> concurrentHashMap = this.dispatchPatternMap.get(tenantDomain);
        if (concurrentHashMap != null && concurrentHashMap.containsKey(port)) {
            concurrentHashMap.remove(port);
        }
    }

    public Pattern getPattern(String tenantDomain, int port) {
        Pattern val;
        ConcurrentHashMap<Integer, Pattern> concurrentHashMap = this.dispatchPatternMap.get(tenantDomain);
        if (concurrentHashMap != null && (val = concurrentHashMap.get(port)) instanceof Pattern) {
            return val;
        }
        return null;
    }

    protected Pattern compilePattern(String dispatchPattern) {
        try {
            return Pattern.compile(dispatchPattern, 36);
        }
        catch (PatternSyntaxException e) {
            log.error((Object)("Dispatch pattern " + dispatchPattern + " is an invalid pattern."));
            throw new SynapseException((Throwable)e);
        }
    }

    public InternalAPIDispatcher getInternalHttpApiDispatcher() {
        return this.internalHttpApiDispatcher;
    }

    public InternalAPIDispatcher getInternalHttpsApiDispatcher() {
        return this.internalHttpsApiDispatcher;
    }

    public int getInternalInboundHttpPort() {
        return this.internalInboundHttpPort;
    }

    public int getInternalInboundHttpsPort() {
        return this.internalInboundHttpsPort;
    }

    public boolean isAnyInternalHttpApiEnabled() {
        return this.internalHttpApiEnabled;
    }

    public boolean isAnyInternalHttpsApiEnabled() {
        return this.internalHttpsApiEnabled;
    }
}

