/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.generic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.startup.quartz.StartUpController;
import org.apache.synapse.task.TaskStartupObserver;
import org.wso2.carbon.inbound.endpoint.common.InboundRequestProcessorImpl;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericPollingConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericTask;

public class GenericProcessor
extends InboundRequestProcessorImpl
implements TaskStartupObserver {
    private GenericPollingConsumer pollingConsumer;
    private Properties properties;
    private String injectingSeq;
    private String onErrorSeq;
    private static final Log log = LogFactory.getLog(GenericProcessor.class);
    private StartUpController startUpController;
    private String classImpl;
    private boolean sequential;
    private static final String ENDPOINT_POSTFIX = "CLASS--SYNAPSE_INBOUND_ENDPOINT";

    public GenericProcessor(String name, String classImpl, Properties properties, long scanInterval, String injectingSeq, String onErrorSeq, SynapseEnvironment synapseEnvironment, boolean coordination, boolean sequential) {
        this.name = name;
        this.properties = properties;
        this.interval = scanInterval;
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.synapseEnvironment = synapseEnvironment;
        this.classImpl = classImpl;
        this.coordination = coordination;
        this.sequential = sequential;
    }

    public GenericProcessor(InboundProcessorParams params) {
        this.name = params.getName();
        this.properties = params.getProperties();
        this.interval = Long.parseLong(this.properties.getProperty("interval"));
        this.coordination = true;
        if (this.properties.getProperty("coordination") != null) {
            this.coordination = Boolean.parseBoolean(this.properties.getProperty("coordination"));
        }
        this.sequential = true;
        if (this.properties.getProperty("sequential") != null) {
            this.sequential = Boolean.parseBoolean(this.properties.getProperty("sequential"));
        }
        this.injectingSeq = params.getInjectingSeq();
        this.onErrorSeq = params.getOnErrorSeq();
        this.synapseEnvironment = params.getSynapseEnvironment();
        this.classImpl = params.getClassImpl();
    }

    public void init() {
        log.info((Object)("Inbound listener " + this.name + " for class " + this.classImpl + " starting ..."));
        try {
            Class<?> c = Class.forName(this.classImpl);
            Constructor<?> cons = c.getConstructor(Properties.class, String.class, SynapseEnvironment.class, Long.TYPE, String.class, String.class, Boolean.TYPE, Boolean.TYPE);
            this.pollingConsumer = (GenericPollingConsumer)cons.newInstance(this.properties, this.name, this.synapseEnvironment, this.interval, this.injectingSeq, this.onErrorSeq, this.coordination, this.sequential);
        }
        catch (ClassNotFoundException e) {
            this.handleException("Class " + this.classImpl + " not found. Please check the required class is added to the classpath.", e);
        }
        catch (NoSuchMethodException e) {
            this.handleException("Required constructor is not implemented.", e);
        }
        catch (InvocationTargetException e) {
            this.handleException("Unable to create the consumer", e);
        }
        catch (Exception e) {
            this.handleException("Unable to create the consumer", e);
        }
        this.start();
    }

    private void handleException(String msg, Exception ex) {
        log.error((Object)msg, (Throwable)ex);
        throw new SynapseException((Throwable)ex);
    }

    public void start() {
        try {
            GenericTask task = new GenericTask(this.pollingConsumer, this.interval);
            this.start(task, ENDPOINT_POSTFIX);
        }
        catch (Exception e) {
            log.error((Object)("Could not start Generic Processor. Error starting up scheduler. Error: " + e.getLocalizedMessage()));
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.pollingConsumer.destroy();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void update() {
        this.start();
    }
}

