/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.generic;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundRequestProcessor;

public abstract class GenericInboundListener
implements InboundRequestProcessor {
    private static final Log log = LogFactory.getLog(GenericInboundListener.class);
    public static final String PARAM_INBOUND_ENDPOINT_BEHAVIOR = "inbound.behavior";
    public static final String PARAM_INBOUND_ENDPOINT_BEHAVIOR_LISTENING = "listening";
    protected String injectingSequence;
    protected String onErrorSequence;
    protected String name;
    protected InboundProcessorParams params;

    public GenericInboundListener(InboundProcessorParams inboundParams) {
        this.injectingSequence = inboundParams.getInjectingSeq();
        this.onErrorSequence = inboundParams.getOnErrorSeq();
        this.name = inboundParams.getName();
        this.params = inboundParams;
    }

    public static synchronized GenericInboundListener getInstance(InboundProcessorParams inboundParams) {
        String classImpl = inboundParams.getClassImpl();
        String name = inboundParams.getName();
        if (null == classImpl) {
            String msg = "GenericEndpointManager class not found";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        GenericInboundListener instance = null;
        log.info((Object)("Inbound listener " + name + " for class " + classImpl + " starting ..."));
        try {
            Class<?> c = Class.forName(classImpl);
            Constructor<?> cons = c.getConstructor(InboundProcessorParams.class);
            instance = (GenericInboundListener)cons.newInstance(inboundParams);
        }
        catch (ClassNotFoundException e) {
            GenericInboundListener.handleException("Class " + classImpl + " not found. Please check the required class is added to the classpath.", e);
        }
        catch (Exception e) {
            GenericInboundListener.handleException("Unable to create the consumer", e);
        }
        return instance;
    }

    public static boolean isListeningInboundEndpoint(InboundProcessorParams inboundParameters) {
        return inboundParameters.getProperties().containsKey(PARAM_INBOUND_ENDPOINT_BEHAVIOR) && PARAM_INBOUND_ENDPOINT_BEHAVIOR_LISTENING.equals(inboundParameters.getProperties().getProperty(PARAM_INBOUND_ENDPOINT_BEHAVIOR));
    }

    protected static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }
}

