/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.format.DataSourceMessageBuilder;
import org.apache.axis2.format.ManagedDataSource;
import org.apache.axis2.format.ManagedDataSourceFactory;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.vfs.FileObjectDataSource;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class FileInjectHandler {
    private static final Log log = LogFactory.getLog(FileInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private Properties vfsProperties;
    private SynapseEnvironment synapseEnvironment;
    private Map<String, Object> transportHeaders;

    public FileInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment, Properties vfsProperties) {
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
        this.vfsProperties = vfsProperties;
    }

    public boolean invoke(Object object, String name) throws SynapseException {
        ManagedDataSource dataSource = null;
        FileObject file = (FileObject)object;
        InputStream in = null;
        try {
            SequenceMediator seq;
            SOAPBuilder builder;
            org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
            msgCtx.setProperty("inbound.endpoint.name", (Object)name);
            msgCtx.setProperty("isInbound", (Object)true);
            InboundEndpoint inboundEndpoint = msgCtx.getConfiguration().getInboundEndpoint(name);
            CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
            String contentType = this.vfsProperties.getProperty("transport.vfs.ContentType");
            if (contentType == null || contentType.trim().equals("")) {
                if (file.getName().getExtension().toLowerCase().endsWith("xml")) {
                    contentType = "text/xml";
                } else if (file.getName().getExtension().toLowerCase().endsWith("txt")) {
                    contentType = "text/plain";
                }
            } else {
                String charSetEnc = null;
                try {
                    if (contentType != null) {
                        charSetEnc = new ContentType(contentType).getParameter("charset");
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                msgCtx.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed file : " + file + " of Content-type : " + contentType));
            }
            MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
            if (contentType == null) {
                log.debug((Object)"No content type specified. Using SOAP builder.");
                builder = new SOAPBuilder();
            } else {
                int index = contentType.indexOf(59);
                String type = index > 0 ? contentType.substring(0, index) : contentType;
                builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
                if (builder == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                    }
                    builder = new SOAPBuilder();
                }
            }
            String streaming = this.vfsProperties.getProperty("transport.vfs.Streaming");
            if (builder instanceof DataSourceMessageBuilder && "true".equals(streaming)) {
                dataSource = ManagedDataSourceFactory.create((DataSource)new FileObjectDataSource(file, contentType));
                in = null;
            } else {
                in = new AutoCloseInputStream(file.getContent().getInputStream());
                dataSource = null;
            }
            OMElement documentElement = in != null ? builder.processDocument(in, contentType, axis2MsgCtx) : ((DataSourceMessageBuilder)builder).processDocument((DataSource)dataSource, contentType, axis2MsgCtx);
            if ("true".equals(this.vfsProperties.getProperty("transport.vfs.Build"))) {
                documentElement.build();
            }
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
            if (this.injectingSeq == null || this.injectingSeq.equals("")) {
                log.error((Object)("Sequence name not specified. Sequence : " + this.injectingSeq));
            }
            if ((seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.injectingSeq)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
                }
                if (!seq.isInitialized()) {
                    seq.init(this.synapseEnvironment);
                }
                seq.setErrorHandler(this.onErrorSeq);
                if (!this.synapseEnvironment.injectInbound(msgCtx, seq, this.sequential)) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
            }
        }
        catch (SynapseException se) {
            throw se;
        }
        catch (Exception e) {
            log.error((Object)"Error while processing the file/folder", (Throwable)e);
            throw new SynapseException("Error while processing the file/folder", (Throwable)e);
        }
        finally {
            if (dataSource != null) {
                dataSource.destroy();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing the input stream", (Throwable)e);
            }
        }
        return true;
    }

    public void setTransportHeaders(Map<String, Object> transportHeaders) {
        this.transportHeaders = transportHeaders;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUIDGenerator.getUUID());
        axis2MsgCtx.setProperty("TRANSPORT_HEADERS", this.transportHeaders);
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        axis2MsgCtx.setProperty("tenantDomain", (Object)carbonContext.getTenantDomain());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        return msgCtx;
    }
}

