/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.common.OneTimeTriggerInboundTask;
import org.wso2.carbon.mediation.clustering.ClusteringAgentUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class OneTimeTriggerInboundRunner
implements Runnable {
    private OneTimeTriggerInboundTask task;
    private volatile boolean execute = true;
    private volatile boolean init = false;
    private String tenantDomain;
    private static final long CLUSTER_CONFIGURATION_CHECK_INTERVAL = 1000L;
    private static final Log log = LogFactory.getLog(OneTimeTriggerInboundRunner.class);

    public OneTimeTriggerInboundRunner(OneTimeTriggerInboundTask task, String tenantDomain) {
        this.task = task;
        this.tenantDomain = tenantDomain;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting the Inbound Endpoint.");
        }
        while (!this.init) {
            Boolean isSinglNode;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for the configuration context to be loaded to run Inbound Endpoint.");
            }
            if ((isSinglNode = ClusteringAgentUtil.isSingleNode()) != null) {
                if (!isSinglNode.booleanValue() && !CarbonUtils.isWorkerNode()) {
                    this.execute = false;
                    log.info((Object)"Inbound Endpoint will not run in manager node. Same will run on worker(s).");
                }
                this.init = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Unable to sleep the Inbound thread for interval of : 1000ms.");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration context loaded. Ready to Run the Inbound Endpoint.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing One-Time trigger connection consumer task in Inbound Endpoint.");
        }
        try {
            if (this.execute) {
                this.task.taskExecute();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error executing the Inbound Endpoint once time execution", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exiting the Inbound Endpoint.");
        }
    }
}

