/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.apache.synapse.startup.quartz.StartUpController;
import org.apache.synapse.task.TaskDescription;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.OneTimeTriggerInboundRunner;
import org.wso2.carbon.inbound.endpoint.common.OneTimeTriggerInboundTask;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointsDataStore;

public abstract class InboundOneTimeTriggerRequestProcessor
implements InboundRequestProcessor {
    protected StartUpController startUpController;
    protected SynapseEnvironment synapseEnvironment;
    protected String name;
    protected boolean coordination;
    private OneTimeTriggerInboundRunner inboundRunner;
    private Thread runningThread;
    private static final Log log = LogFactory.getLog(InboundOneTimeTriggerRequestProcessor.class);
    private InboundEndpointsDataStore dataStore = InboundEndpointsDataStore.getInstance();
    protected static final String COMMON_ENDPOINT_POSTFIX = "--SYNAPSE_INBOUND_ENDPOINT";
    public static final int TASK_THRESHOLD_INTERVAL = 1000;

    protected void start(OneTimeTriggerInboundTask task, String endpointPostfix) {
        log.info((Object)("Starting the inbound endpoint " + this.name + ", with coordination " + this.coordination + ". Type : " + endpointPostfix));
        if (this.coordination) {
            try {
                TaskDescription taskDescription = new TaskDescription();
                taskDescription.setName(this.name + "-" + endpointPostfix);
                taskDescription.setTaskGroup(endpointPostfix);
                taskDescription.setInterval(1000L);
                taskDescription.setIntervalInMs(true);
                taskDescription.addResource("Instance", (Object)task);
                taskDescription.addResource("ClassName", (Object)task.getClass().getName());
                this.startUpController = new StartUpController();
                this.startUpController.setTaskDescription(taskDescription);
                this.startUpController.init(this.synapseEnvironment);
            }
            catch (Exception e) {
                log.error((Object)("Error starting the inbound endpoint " + this.name + ". Unable to schedule the task. " + e.getLocalizedMessage()), (Throwable)e);
            }
        } else {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            int tenantId = carbonContext.getTenantId();
            String tenantDomain = null;
            if (tenantId != -1234 && !this.dataStore.isPollingEndpointRegistered(tenantDomain = carbonContext.getTenantDomain(), this.name)) {
                this.dataStore.registerPollingingEndpoint(tenantDomain, this.name);
            }
            this.inboundRunner = new OneTimeTriggerInboundRunner(task, tenantDomain);
            if (task.getCallback() != null) {
                task.getCallback().setInboundRunnerMode(true);
            }
            if (task.getCallback() != null) {
                task.getCallback().setTenantDomain(tenantDomain);
            }
            this.runningThread = new Thread(this.inboundRunner);
            this.runningThread.start();
        }
    }

    public void destroy() {
        log.info((Object)("Inbound endpoint " + this.name + " stopping."));
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        int tenantId = carbonContext.getTenantId();
        if (tenantId != -1234) {
            this.dataStore.unregisterPollingEndpoint(carbonContext.getTenantDomain(), this.name);
        }
        if (this.startUpController != null) {
            this.startUpController.destroy();
        } else if (this.runningThread != null) {
            try {
                this.runningThread.join();
            }
            catch (InterruptedException e) {
                log.error((Object)"Error while stopping the inbound thread.");
            }
        }
    }
}

