/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRuleBinding
extends RuleBinding<MessageRule> {
    private String myMessageType;
    private String myTriggerEvent;
    private static final String delim = "^";

    public MessageRuleBinding(String theVersion, String theMessageType, String theTriggerEvent, MessageRule theRule) {
        super(theVersion, theMessageType + delim + theTriggerEvent, theRule);
        this.myMessageType = theMessageType;
        this.myTriggerEvent = theTriggerEvent;
    }

    @Override
    public boolean appliesToScope(String theScope) {
        if (!theScope.matches(".*\\^.*")) {
            throw new IllegalArgumentException("arg theScope must be of the form type^event");
        }
        StringTokenizer tok = new StringTokenizer(theScope, delim, false);
        String itemType = tok.nextToken();
        String itemEvent = tok.nextToken();
        return MessageRuleBinding.applies(this.myMessageType, itemType) && MessageRuleBinding.applies(this.myTriggerEvent, itemEvent);
    }
}

