/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.JMSDestination;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class JMSTopicAdapter
implements JMSDestination {
    private TopicSession mySendingSession;
    private TopicSession myReceivingSession;
    private TopicPublisher myPublisher;
    private TopicSubscriber mySubscriber;
    private TopicConnection myConnection;
    private Topic myTopic;
    private boolean myIsConnected;

    public JMSTopicAdapter(TopicConnection theConnection, Topic theDestination) {
        this.myConnection = theConnection;
        this.myTopic = theDestination;
    }

    public JMSTopicAdapter(TopicConnection theConnection, Topic theDestination, String theMessageSelector) {
        this.myConnection = theConnection;
        this.myTopic = theDestination;
    }

    public String getName() throws JMSException {
        return this.myTopic.getTopicName();
    }

    public TextMessage createMessage() throws JMSException {
        return this.mySendingSession.createTextMessage();
    }

    public void connect() throws JMSException {
        boolean transacted = false;
        int ackMode = 1;
        this.disconnect();
        this.mySendingSession = this.myConnection.createTopicSession(transacted, ackMode);
        this.myPublisher = this.mySendingSession.createPublisher(this.myTopic);
        this.myReceivingSession = this.myConnection.createTopicSession(transacted, ackMode);
        this.mySubscriber = this.myReceivingSession.createSubscriber(this.myTopic);
        this.myIsConnected = true;
    }

    public void disconnect() throws JMSException {
        this.myIsConnected = false;
        if (this.mySendingSession != null) {
            this.mySendingSession.close();
        }
        if (this.myReceivingSession != null) {
            this.myReceivingSession.close();
        }
    }

    public boolean isConnected() {
        return this.myIsConnected;
    }

    public void send(Message theMessage) throws JMSException {
        this.myPublisher.publish(theMessage);
    }

    public Message receive() throws JMSException {
        return this.mySubscriber.receive();
    }

    public Connection getConnection() {
        return this.myConnection;
    }
}

