/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ODT
extends AbstractSegment {
    public ODT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Tray Type");
            this.add(CWE.class, false, 10, 250, new Object[]{this.getMessage()}, "Service Period");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Text Instruction");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ODT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getTrayType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getOdt1_TrayType() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getServicePeriod() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public CWE[] getOdt2_ServicePeriod() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public int getServicePeriodReps() {
        return this.getReps(2);
    }

    public CWE getServicePeriod(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getOdt2_ServicePeriod(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getOdt2_ServicePeriodReps() {
        return this.getReps(2);
    }

    public CWE insertServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertOdt2_ServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeOdt2_ServicePeriod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public ST getTextInstruction() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getOdt3_TextInstruction() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

