/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IVC
extends AbstractSegment {
    public IVC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 74, new Object[]{this.getMessage()}, "Provider Invoice Number");
            this.add(EI.class, false, 1, 74, new Object[]{this.getMessage()}, "Payer Invoice Number");
            this.add(EI.class, false, 1, 74, new Object[]{this.getMessage()}, "Contract/Agreement Number");
            this.add(IS.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(553)}, "Invoice Control");
            this.add(IS.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(554)}, "Invoice Reason");
            this.add(IS.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(555)}, "Invoice Type");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Invoice Date/Time");
            this.add(CP.class, true, 1, 254, new Object[]{this.getMessage()}, "Invoice Amount");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Payment Terms");
            this.add(XON.class, true, 1, 183, new Object[]{this.getMessage()}, "Provider Organization");
            this.add(XON.class, true, 1, 183, new Object[]{this.getMessage()}, "Payer Organization");
            this.add(XCN.class, false, 1, 637, new Object[]{this.getMessage()}, "Attention");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Last Invoice Indicator");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Invoice Booking Period");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Origin");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Invoice Fixed Amount");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Special Costs");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Amount for Doctors Treatment");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Responsible Physician");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Cost Center");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Invoice Prepaid Amount");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Total Invoice Amount without Prepaid Amount");
            this.add(CP.class, false, 1, 254, new Object[]{this.getMessage()}, "Total-Amount of VAT");
            this.add(NM.class, false, 0, 1024, new Object[]{this.getMessage()}, "VAT-Rates applied");
            this.add(IS.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(556)}, "Benefit Group");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Provider Tax ID");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Payer Tax ID");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(572)}, "Provider Tax status");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(572)}, "Payer Tax status");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Sales Tax ID");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating IVC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getProviderInvoiceNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getIvc1_ProviderInvoiceNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPayerInvoiceNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getIvc2_PayerInvoiceNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getContractAgreementNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getIvc3_ContractAgreementNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getInvoiceControl() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getIvc4_InvoiceControl() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getInvoiceReason() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getIvc5_InvoiceReason() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getInvoiceType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getIvc6_InvoiceType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getInvoiceDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getIvc7_InvoiceDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public CP getInvoiceAmount() {
        CP retVal = (CP)this.getTypedField(8, 0);
        return retVal;
    }

    public CP getIvc8_InvoiceAmount() {
        CP retVal = (CP)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getPaymentTerms() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getIvc9_PaymentTerms() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public XON getProviderOrganization() {
        XON retVal = (XON)this.getTypedField(10, 0);
        return retVal;
    }

    public XON getIvc10_ProviderOrganization() {
        XON retVal = (XON)this.getTypedField(10, 0);
        return retVal;
    }

    public XON getPayerOrganization() {
        XON retVal = (XON)this.getTypedField(11, 0);
        return retVal;
    }

    public XON getIvc11_PayerOrganization() {
        XON retVal = (XON)this.getTypedField(11, 0);
        return retVal;
    }

    public XCN getAttention() {
        XCN retVal = (XCN)this.getTypedField(12, 0);
        return retVal;
    }

    public XCN getIvc12_Attention() {
        XCN retVal = (XCN)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getLastInvoiceIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getIvc13_LastInvoiceIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getInvoiceBookingPeriod() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getIvc14_InvoiceBookingPeriod() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getOrigin() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getIvc15_Origin() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public CP getInvoiceFixedAmount() {
        CP retVal = (CP)this.getTypedField(16, 0);
        return retVal;
    }

    public CP getIvc16_InvoiceFixedAmount() {
        CP retVal = (CP)this.getTypedField(16, 0);
        return retVal;
    }

    public CP getSpecialCosts() {
        CP retVal = (CP)this.getTypedField(17, 0);
        return retVal;
    }

    public CP getIvc17_SpecialCosts() {
        CP retVal = (CP)this.getTypedField(17, 0);
        return retVal;
    }

    public CP getAmountForDoctorsTreatment() {
        CP retVal = (CP)this.getTypedField(18, 0);
        return retVal;
    }

    public CP getIvc18_AmountForDoctorsTreatment() {
        CP retVal = (CP)this.getTypedField(18, 0);
        return retVal;
    }

    public XCN getResponsiblePhysician() {
        XCN retVal = (XCN)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getIvc19_ResponsiblePhysician() {
        XCN retVal = (XCN)this.getTypedField(19, 0);
        return retVal;
    }

    public CX getCostCenter() {
        CX retVal = (CX)this.getTypedField(20, 0);
        return retVal;
    }

    public CX getIvc20_CostCenter() {
        CX retVal = (CX)this.getTypedField(20, 0);
        return retVal;
    }

    public CP getInvoicePrepaidAmount() {
        CP retVal = (CP)this.getTypedField(21, 0);
        return retVal;
    }

    public CP getIvc21_InvoicePrepaidAmount() {
        CP retVal = (CP)this.getTypedField(21, 0);
        return retVal;
    }

    public CP getTotalInvoiceAmountWithoutPrepaidAmount() {
        CP retVal = (CP)this.getTypedField(22, 0);
        return retVal;
    }

    public CP getIvc22_TotalInvoiceAmountWithoutPrepaidAmount() {
        CP retVal = (CP)this.getTypedField(22, 0);
        return retVal;
    }

    public CP getTotalAmountOfVAT() {
        CP retVal = (CP)this.getTypedField(23, 0);
        return retVal;
    }

    public CP getIvc23_TotalAmountOfVAT() {
        CP retVal = (CP)this.getTypedField(23, 0);
        return retVal;
    }

    public NM[] getVATRatesApplied() {
        NM[] retVal = (NM[])this.getTypedField(24, new NM[0]);
        return retVal;
    }

    public NM[] getIvc24_VATRatesApplied() {
        NM[] retVal = (NM[])this.getTypedField(24, new NM[0]);
        return retVal;
    }

    public int getVATRatesAppliedReps() {
        return this.getReps(24);
    }

    public NM getVATRatesApplied(int rep) {
        NM retVal = (NM)this.getTypedField(24, rep);
        return retVal;
    }

    public NM getIvc24_VATRatesApplied(int rep) {
        NM retVal = (NM)this.getTypedField(24, rep);
        return retVal;
    }

    public int getIvc24_VATRatesAppliedReps() {
        return this.getReps(24);
    }

    public NM insertVATRatesApplied(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(24, rep);
    }

    public NM insertIvc24_VATRatesApplied(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(24, rep);
    }

    public NM removeVATRatesApplied(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(24, rep);
    }

    public NM removeIvc24_VATRatesApplied(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(24, rep);
    }

    public IS getBenefitGroup() {
        IS retVal = (IS)this.getTypedField(25, 0);
        return retVal;
    }

    public IS getIvc25_BenefitGroup() {
        IS retVal = (IS)this.getTypedField(25, 0);
        return retVal;
    }

    public ST getProviderTaxID() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ST getIvc26_ProviderTaxID() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ST getPayerTaxID() {
        ST retVal = (ST)this.getTypedField(27, 0);
        return retVal;
    }

    public ST getIvc27_PayerTaxID() {
        ST retVal = (ST)this.getTypedField(27, 0);
        return retVal;
    }

    public IS getProviderTaxStatus() {
        IS retVal = (IS)this.getTypedField(28, 0);
        return retVal;
    }

    public IS getIvc28_ProviderTaxStatus() {
        IS retVal = (IS)this.getTypedField(28, 0);
        return retVal;
    }

    public IS getPayerTaxStatus() {
        IS retVal = (IS)this.getTypedField(29, 0);
        return retVal;
    }

    public IS getIvc29_PayerTaxStatus() {
        IS retVal = (IS)this.getTypedField(29, 0);
        return retVal;
    }

    public ST getSalesTaxID() {
        ST retVal = (ST)this.getTypedField(30, 0);
        return retVal;
    }

    public ST getIvc30_SalesTaxID() {
        ST retVal = (ST)this.getTypedField(30, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(553));
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(554));
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(555));
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new CP(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new XON(this.getMessage());
            }
            case 10: {
                return new XON(this.getMessage());
            }
            case 11: {
                return new XCN(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 13: {
                return new DTM(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new CP(this.getMessage());
            }
            case 16: {
                return new CP(this.getMessage());
            }
            case 17: {
                return new CP(this.getMessage());
            }
            case 18: {
                return new XCN(this.getMessage());
            }
            case 19: {
                return new CX(this.getMessage());
            }
            case 20: {
                return new CP(this.getMessage());
            }
            case 21: {
                return new CP(this.getMessage());
            }
            case 22: {
                return new CP(this.getMessage());
            }
            case 23: {
                return new NM(this.getMessage());
            }
            case 24: {
                return new IS(this.getMessage(), new Integer(556));
            }
            case 25: {
                return new ST(this.getMessage());
            }
            case 26: {
                return new ST(this.getMessage());
            }
            case 27: {
                return new IS(this.getMessage(), new Integer(572));
            }
            case 28: {
                return new IS(this.getMessage(), new Integer(572));
            }
            case 29: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

