/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GP2
extends AbstractSegment {
    public GP2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(456)}, "Revenue Code");
            this.add(NM.class, false, 1, 7, new Object[]{this.getMessage()}, "Number of Service Units");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Charge");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(459)}, "Reimbursement Action Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(460)}, "Denial or Rejection Code");
            this.add(IS.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(458)}, "OCE Edit Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Ambulatory Payment Classification Code");
            this.add(IS.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(467)}, "Modifier Edit Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(468)}, "Payment Adjustment Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(469)}, "Packaging Status Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Expected CMS Payment Amount");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(470)}, "Reimbursement Type Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Co-Pay Amount");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Pay Rate per Service Unit");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating GP2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public IS getRevenueCode() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getGp21_RevenueCode() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getNumberOfServiceUnits() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getGp22_NumberOfServiceUnits() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public CP getCharge() {
        CP retVal = (CP)this.getTypedField(3, 0);
        return retVal;
    }

    public CP getGp23_Charge() {
        CP retVal = (CP)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getReimbursementActionCode() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getGp24_ReimbursementActionCode() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getDenialOrRejectionCode() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getGp25_DenialOrRejectionCode() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS[] getOCEEditCode() {
        IS[] retVal = (IS[])this.getTypedField(6, new IS[0]);
        return retVal;
    }

    public IS[] getGp26_OCEEditCode() {
        IS[] retVal = (IS[])this.getTypedField(6, new IS[0]);
        return retVal;
    }

    public int getOCEEditCodeReps() {
        return this.getReps(6);
    }

    public IS getOCEEditCode(int rep) {
        IS retVal = (IS)this.getTypedField(6, rep);
        return retVal;
    }

    public IS getGp26_OCEEditCode(int rep) {
        IS retVal = (IS)this.getTypedField(6, rep);
        return retVal;
    }

    public int getGp26_OCEEditCodeReps() {
        return this.getReps(6);
    }

    public IS insertOCEEditCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(6, rep);
    }

    public IS insertGp26_OCEEditCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(6, rep);
    }

    public IS removeOCEEditCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(6, rep);
    }

    public IS removeGp26_OCEEditCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(6, rep);
    }

    public CWE getAmbulatoryPaymentClassificationCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getGp27_AmbulatoryPaymentClassificationCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public IS[] getModifierEditCode() {
        IS[] retVal = (IS[])this.getTypedField(8, new IS[0]);
        return retVal;
    }

    public IS[] getGp28_ModifierEditCode() {
        IS[] retVal = (IS[])this.getTypedField(8, new IS[0]);
        return retVal;
    }

    public int getModifierEditCodeReps() {
        return this.getReps(8);
    }

    public IS getModifierEditCode(int rep) {
        IS retVal = (IS)this.getTypedField(8, rep);
        return retVal;
    }

    public IS getGp28_ModifierEditCode(int rep) {
        IS retVal = (IS)this.getTypedField(8, rep);
        return retVal;
    }

    public int getGp28_ModifierEditCodeReps() {
        return this.getReps(8);
    }

    public IS insertModifierEditCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(8, rep);
    }

    public IS insertGp28_ModifierEditCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(8, rep);
    }

    public IS removeModifierEditCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(8, rep);
    }

    public IS removeGp28_ModifierEditCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(8, rep);
    }

    public IS getPaymentAdjustmentCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getGp29_PaymentAdjustmentCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getPackagingStatusCode() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getGp210_PackagingStatusCode() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public CP getExpectedCMSPaymentAmount() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public CP getGp211_ExpectedCMSPaymentAmount() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getReimbursementTypeCode() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public IS getGp212_ReimbursementTypeCode() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getCoPayAmount() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CP getGp213_CoPayAmount() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getPayRatePerServiceUnit() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getGp214_PayRatePerServiceUnit() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new IS(this.getMessage(), new Integer(456));
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new CP(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(459));
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(460));
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(458));
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(467));
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(468));
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(469));
            }
            case 10: {
                return new CP(this.getMessage());
            }
            case 11: {
                return new IS(this.getMessage(), new Integer(470));
            }
            case 12: {
                return new CP(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

