/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_RESULT;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_TIMING_QTY;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPU_R25_ORDER
extends AbstractGroup {
    public OPU_R25_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(ORC.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(OPU_R25_TIMING_QTY.class, false, true, false);
            this.add(OPU_R25_RESULT.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OPU_R25_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ROL getROL() {
        ROL retVal = this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public OPU_R25_TIMING_QTY getTIMING_QTY() {
        OPU_R25_TIMING_QTY retVal = this.getTyped("TIMING_QTY", OPU_R25_TIMING_QTY.class);
        return retVal;
    }

    public OPU_R25_TIMING_QTY getTIMING_QTY(int rep) {
        OPU_R25_TIMING_QTY retVal = this.getTyped("TIMING_QTY", rep, OPU_R25_TIMING_QTY.class);
        return retVal;
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<OPU_R25_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", OPU_R25_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(OPU_R25_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", structure, rep);
    }

    public OPU_R25_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (OPU_R25_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public OPU_R25_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (OPU_R25_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public OPU_R25_RESULT getRESULT() {
        OPU_R25_RESULT retVal = this.getTyped("RESULT", OPU_R25_RESULT.class);
        return retVal;
    }

    public OPU_R25_RESULT getRESULT(int rep) {
        OPU_R25_RESULT retVal = this.getTyped("RESULT", rep, OPU_R25_RESULT.class);
        return retVal;
    }

    public int getRESULTReps() {
        return this.getReps("RESULT");
    }

    public List<OPU_R25_RESULT> getRESULTAll() throws HL7Exception {
        return this.getAllAsList("RESULT", OPU_R25_RESULT.class);
    }

    public void insertRESULT(OPU_R25_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULT", structure, rep);
    }

    public OPU_R25_RESULT insertRESULT(int rep) throws HL7Exception {
        return (OPU_R25_RESULT)super.insertRepetition("RESULT", rep);
    }

    public OPU_R25_RESULT removeRESULT(int rep) throws HL7Exception {
        return (OPU_R25_RESULT)super.removeRepetition("RESULT", rep);
    }
}

