/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.EHC_E20_DIAGNOSIS;
import ca.uhn.hl7v2.model.v26.group.EHC_E20_INSURANCE;
import ca.uhn.hl7v2.model.v26.segment.ACC;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHC_E20_PAT_INFO
extends AbstractGroup {
    public EHC_E20_PAT_INFO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, true);
            this.add(ACC.class, false, true, true);
            this.add(EHC_E20_INSURANCE.class, true, true, false);
            this.add(EHC_E20_DIAGNOSIS.class, false, true, false);
            this.add(OBX.class, false, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating EHC_E20_PAT_INFO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public ACC getACC() {
        ACC retVal = this.getTyped("ACC", ACC.class);
        return retVal;
    }

    public ACC getACC(int rep) {
        ACC retVal = this.getTyped("ACC", rep, ACC.class);
        return retVal;
    }

    public int getACCReps() {
        return this.getReps("ACC");
    }

    public List<ACC> getACCAll() throws HL7Exception {
        return this.getAllAsList("ACC", ACC.class);
    }

    public void insertACC(ACC structure, int rep) throws HL7Exception {
        super.insertRepetition("ACC", structure, rep);
    }

    public ACC insertACC(int rep) throws HL7Exception {
        return (ACC)super.insertRepetition("ACC", rep);
    }

    public ACC removeACC(int rep) throws HL7Exception {
        return (ACC)super.removeRepetition("ACC", rep);
    }

    public EHC_E20_INSURANCE getINSURANCE() {
        EHC_E20_INSURANCE retVal = this.getTyped("INSURANCE", EHC_E20_INSURANCE.class);
        return retVal;
    }

    public EHC_E20_INSURANCE getINSURANCE(int rep) {
        EHC_E20_INSURANCE retVal = this.getTyped("INSURANCE", rep, EHC_E20_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<EHC_E20_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", EHC_E20_INSURANCE.class);
    }

    public void insertINSURANCE(EHC_E20_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public EHC_E20_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (EHC_E20_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public EHC_E20_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (EHC_E20_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public EHC_E20_DIAGNOSIS getDIAGNOSIS() {
        EHC_E20_DIAGNOSIS retVal = this.getTyped("DIAGNOSIS", EHC_E20_DIAGNOSIS.class);
        return retVal;
    }

    public EHC_E20_DIAGNOSIS getDIAGNOSIS(int rep) {
        EHC_E20_DIAGNOSIS retVal = this.getTyped("DIAGNOSIS", rep, EHC_E20_DIAGNOSIS.class);
        return retVal;
    }

    public int getDIAGNOSISReps() {
        return this.getReps("DIAGNOSIS");
    }

    public List<EHC_E20_DIAGNOSIS> getDIAGNOSISAll() throws HL7Exception {
        return this.getAllAsList("DIAGNOSIS", EHC_E20_DIAGNOSIS.class);
    }

    public void insertDIAGNOSIS(EHC_E20_DIAGNOSIS structure, int rep) throws HL7Exception {
        super.insertRepetition("DIAGNOSIS", structure, rep);
    }

    public EHC_E20_DIAGNOSIS insertDIAGNOSIS(int rep) throws HL7Exception {
        return (EHC_E20_DIAGNOSIS)super.insertRepetition("DIAGNOSIS", rep);
    }

    public EHC_E20_DIAGNOSIS removeDIAGNOSIS(int rep) throws HL7Exception {
        return (EHC_E20_DIAGNOSIS)super.removeRepetition("DIAGNOSIS", rep);
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

