/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM5
extends AbstractSegment {
    public OM5(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Test/Observations Included within an Ordered Test Battery");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Observation ID Suffixes");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OM5 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm51_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getTestObservationsIncludedWithinAnOrderedTestBattery() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getOm52_TestObservationsIncludedWithinAnOrderedTestBattery() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getTestObservationsIncludedWithinAnOrderedTestBatteryReps() {
        return this.getReps(2);
    }

    public CE getTestObservationsIncludedWithinAnOrderedTestBattery(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getOm52_TestObservationsIncludedWithinAnOrderedTestBattery(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getOm52_TestObservationsIncludedWithinAnOrderedTestBatteryReps() {
        return this.getReps(2);
    }

    public CE insertTestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertOm52_TestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeTestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removeOm52_TestObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public ST getObservationIDSuffixes() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getOm53_ObservationIDSuffixes() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

