/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CWE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.PL;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class BPO
extends AbstractSegment {
    public BPO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID _ BPO");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "BP Universal Service ID");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "BP  Processing Requirements");
            this.add(NM.class, true, 1, 5, new Object[]{this.getMessage()}, "BP Quantity");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "BP Amount");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Units");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "BP Intended Use Date/Time");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "BP Intended Dispense From Location");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Intended Dispense From Address");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "BP Requested Dispense Date/Time");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "BP Requested Dispense To Location");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Requested Dispense To Address");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "BP Indication for Use");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "BP Informed Consent Indicator");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating BPO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDBPO() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getBpo1_SetIDBPO() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getBPUniversalServiceID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getBpo2_BPUniversalServiceID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getBPProcessingRequirements() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public CWE[] getBpo3_BPProcessingRequirements() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public int getBPProcessingRequirementsReps() {
        return this.getReps(3);
    }

    public CWE getBPProcessingRequirements(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getBpo3_BPProcessingRequirements(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getBpo3_BPProcessingRequirementsReps() {
        return this.getReps(3);
    }

    public CWE insertBPProcessingRequirements(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertBpo3_BPProcessingRequirements(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeBPProcessingRequirements(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeBpo3_BPProcessingRequirements(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public NM getBPQuantity() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getBpo4_BPQuantity() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getBPAmount() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getBpo5_BPAmount() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getBPUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getBpo6_BPUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getBPIntendedUseDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getBpo7_BPIntendedUseDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public PL getBPIntendedDispenseFromLocation() {
        PL retVal = (PL)this.getTypedField(8, 0);
        return retVal;
    }

    public PL getBpo8_BPIntendedDispenseFromLocation() {
        PL retVal = (PL)this.getTypedField(8, 0);
        return retVal;
    }

    public XAD getBPIntendedDispenseFromAddress() {
        XAD retVal = (XAD)this.getTypedField(9, 0);
        return retVal;
    }

    public XAD getBpo9_BPIntendedDispenseFromAddress() {
        XAD retVal = (XAD)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getBPRequestedDispenseDateTime() {
        TS retVal = (TS)this.getTypedField(10, 0);
        return retVal;
    }

    public TS getBpo10_BPRequestedDispenseDateTime() {
        TS retVal = (TS)this.getTypedField(10, 0);
        return retVal;
    }

    public PL getBPRequestedDispenseToLocation() {
        PL retVal = (PL)this.getTypedField(11, 0);
        return retVal;
    }

    public PL getBpo11_BPRequestedDispenseToLocation() {
        PL retVal = (PL)this.getTypedField(11, 0);
        return retVal;
    }

    public XAD getBPRequestedDispenseToAddress() {
        XAD retVal = (XAD)this.getTypedField(12, 0);
        return retVal;
    }

    public XAD getBpo12_BPRequestedDispenseToAddress() {
        XAD retVal = (XAD)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE[] getBPIndicationForUse() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public CWE[] getBpo13_BPIndicationForUse() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public int getBPIndicationForUseReps() {
        return this.getReps(13);
    }

    public CWE getBPIndicationForUse(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public CWE getBpo13_BPIndicationForUse(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public int getBpo13_BPIndicationForUseReps() {
        return this.getReps(13);
    }

    public CWE insertBPIndicationForUse(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE insertBpo13_BPIndicationForUse(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE removeBPIndicationForUse(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public CWE removeBpo13_BPIndicationForUse(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public ID getBPInformedConsentIndicator() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getBpo14_BPInformedConsentIndicator() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new PL(this.getMessage());
            }
            case 8: {
                return new XAD(this.getMessage());
            }
            case 9: {
                return new TS(this.getMessage());
            }
            case 10: {
                return new PL(this.getMessage());
            }
            case 11: {
                return new XAD(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

