/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.ST;

public class XTN
extends AbstractComposite {
    private Type[] data;

    public XTN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[12];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new ID(this.getMessage(), 201);
        this.data[2] = new ID(this.getMessage(), 202);
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new NM(this.getMessage());
        this.data[5] = new NM(this.getMessage());
        this.data[6] = new NM(this.getMessage());
        this.data[7] = new NM(this.getMessage());
        this.data[8] = new ST(this.getMessage());
        this.data[9] = new ST(this.getMessage());
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ST(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getTelephoneNumber() {
        return this.getTyped(0, ST.class);
    }

    public ST getXtn1_TelephoneNumber() {
        return this.getTyped(0, ST.class);
    }

    public ID getTelecommunicationUseCode() {
        return this.getTyped(1, ID.class);
    }

    public ID getXtn2_TelecommunicationUseCode() {
        return this.getTyped(1, ID.class);
    }

    public ID getTelecommunicationEquipmentType() {
        return this.getTyped(2, ID.class);
    }

    public ID getXtn3_TelecommunicationEquipmentType() {
        return this.getTyped(2, ID.class);
    }

    public ST getEmailAddress() {
        return this.getTyped(3, ST.class);
    }

    public ST getXtn4_EmailAddress() {
        return this.getTyped(3, ST.class);
    }

    public NM getCountryCode() {
        return this.getTyped(4, NM.class);
    }

    public NM getXtn5_CountryCode() {
        return this.getTyped(4, NM.class);
    }

    public NM getAreaCityCode() {
        return this.getTyped(5, NM.class);
    }

    public NM getXtn6_AreaCityCode() {
        return this.getTyped(5, NM.class);
    }

    public NM getLocalNumber() {
        return this.getTyped(6, NM.class);
    }

    public NM getXtn7_LocalNumber() {
        return this.getTyped(6, NM.class);
    }

    public NM getExtension() {
        return this.getTyped(7, NM.class);
    }

    public NM getXtn8_Extension() {
        return this.getTyped(7, NM.class);
    }

    public ST getAnyText() {
        return this.getTyped(8, ST.class);
    }

    public ST getXtn9_AnyText() {
        return this.getTyped(8, ST.class);
    }

    public ST getExtensionPrefix() {
        return this.getTyped(9, ST.class);
    }

    public ST getXtn10_ExtensionPrefix() {
        return this.getTyped(9, ST.class);
    }

    public ST getSpeedDialCode() {
        return this.getTyped(10, ST.class);
    }

    public ST getXtn11_SpeedDialCode() {
        return this.getTyped(10, ST.class);
    }

    public ST getUnformattedTelephoneNumber() {
        return this.getTyped(11, ST.class);
    }

    public ST getXtn12_UnformattedTelephoneNumber() {
        return this.getTyped(11, ST.class);
    }
}

