/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_ABS_RANGE;
import ca.uhn.hl7v2.model.v23.datatype.CM_DLT;
import ca.uhn.hl7v2.model.v23.datatype.CM_RANGE;
import ca.uhn.hl7v2.model.v23.datatype.CM_RFR;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM2
extends AbstractSegment {
    public OM2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/ Observation Master File");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Units of Measure");
            this.add(NM.class, false, 0, 10, new Object[]{this.getMessage()}, "Range of Decimal Precision");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Corresponding SI Units of Measure");
            this.add(TX.class, false, 1, 60, new Object[]{this.getMessage()}, "SI Conversion Factor");
            this.add(CM_RFR.class, false, 1, 200, new Object[]{this.getMessage()}, "Reference (Normal) Range - Ordinal & Continuous Obs");
            this.add(CM_RANGE.class, false, 1, 200, new Object[]{this.getMessage()}, "Critical Range for Ordinal & Continuous Obs");
            this.add(CM_ABS_RANGE.class, false, 1, 200, new Object[]{this.getMessage()}, "Absolute Range for Ordinal & Continuous Obs");
            this.add(CM_DLT.class, false, 0, 200, new Object[]{this.getMessage()}, "Delta Check Criteria");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Minimum Meaningful Increments");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OM2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm21_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getUnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getOm22_UnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public NM[] getRangeOfDecimalPrecision() {
        NM[] retVal = (NM[])this.getTypedField(3, new NM[0]);
        return retVal;
    }

    public NM[] getOm23_RangeOfDecimalPrecision() {
        NM[] retVal = (NM[])this.getTypedField(3, new NM[0]);
        return retVal;
    }

    public int getRangeOfDecimalPrecisionReps() {
        return this.getReps(3);
    }

    public NM getRangeOfDecimalPrecision(int rep) {
        NM retVal = (NM)this.getTypedField(3, rep);
        return retVal;
    }

    public NM getOm23_RangeOfDecimalPrecision(int rep) {
        NM retVal = (NM)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm23_RangeOfDecimalPrecisionReps() {
        return this.getReps(3);
    }

    public NM insertRangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM insertOm23_RangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM removeRangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    public NM removeOm23_RangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    public CE getCorrespondingSIUnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getOm24_CorrespondingSIUnitsOfMeasure() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getSIConversionFactor() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public TX getOm25_SIConversionFactor() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public CM_RFR getReferenceNormalRangeOrdinalContinuousObs() {
        CM_RFR retVal = (CM_RFR)this.getTypedField(6, 0);
        return retVal;
    }

    public CM_RFR getOm26_ReferenceNormalRangeOrdinalContinuousObs() {
        CM_RFR retVal = (CM_RFR)this.getTypedField(6, 0);
        return retVal;
    }

    public CM_RANGE getCriticalRangeForOrdinalContinuousObs() {
        CM_RANGE retVal = (CM_RANGE)this.getTypedField(7, 0);
        return retVal;
    }

    public CM_RANGE getOm27_CriticalRangeForOrdinalContinuousObs() {
        CM_RANGE retVal = (CM_RANGE)this.getTypedField(7, 0);
        return retVal;
    }

    public CM_ABS_RANGE getAbsoluteRangeForOrdinalContinuousObs() {
        CM_ABS_RANGE retVal = (CM_ABS_RANGE)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_ABS_RANGE getOm28_AbsoluteRangeForOrdinalContinuousObs() {
        CM_ABS_RANGE retVal = (CM_ABS_RANGE)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_DLT[] getDeltaCheckCriteria() {
        CM_DLT[] retVal = (CM_DLT[])this.getTypedField(9, new CM_DLT[0]);
        return retVal;
    }

    public CM_DLT[] getOm29_DeltaCheckCriteria() {
        CM_DLT[] retVal = (CM_DLT[])this.getTypedField(9, new CM_DLT[0]);
        return retVal;
    }

    public int getDeltaCheckCriteriaReps() {
        return this.getReps(9);
    }

    public CM_DLT getDeltaCheckCriteria(int rep) {
        CM_DLT retVal = (CM_DLT)this.getTypedField(9, rep);
        return retVal;
    }

    public CM_DLT getOm29_DeltaCheckCriteria(int rep) {
        CM_DLT retVal = (CM_DLT)this.getTypedField(9, rep);
        return retVal;
    }

    public int getOm29_DeltaCheckCriteriaReps() {
        return this.getReps(9);
    }

    public CM_DLT insertDeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.insertRepetition(9, rep);
    }

    public CM_DLT insertOm29_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.insertRepetition(9, rep);
    }

    public CM_DLT removeDeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.removeRepetition(9, rep);
    }

    public CM_DLT removeOm29_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (CM_DLT)super.removeRepetition(9, rep);
    }

    public NM getMinimumMeaningfulIncrements() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getOm210_MinimumMeaningfulIncrements() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new TX(this.getMessage());
            }
            case 5: {
                return new CM_RFR(this.getMessage());
            }
            case 6: {
                return new CM_RANGE(this.getMessage());
            }
            case 7: {
                return new CM_ABS_RANGE(this.getMessage());
            }
            case 8: {
                return new CM_DLT(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

