/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TQ;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXG
extends AbstractSegment {
    public RXG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Give Sub-ID Counter");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Dispense Sub-ID Counter");
            this.add(TQ.class, false, 0, 200, new Object[]{this.getMessage()}, "Quantity / timing");
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Give Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Minimum");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Amount - Maximum");
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Give Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Give Dosage Form");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Administration Notes");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(CM_LA1.class, false, 1, 12, new Object[]{this.getMessage()}, "Deliver-to location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "Needs Human Review");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Pharmacy Special Administration Instructions");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Give Per (Time Unit)");
            this.add(CE.class, false, 1, 6, new Object[]{this.getMessage()}, "Give Rate Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Give Rate Units");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RXG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getGiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRxg1_GiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getDispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxg2_DispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public TQ[] getQuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(3, new TQ[0]);
        return retVal;
    }

    public TQ[] getRxg3_QuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(3, new TQ[0]);
        return retVal;
    }

    public int getQuantityTimingReps() {
        return this.getReps(3);
    }

    public TQ getQuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(3, rep);
        return retVal;
    }

    public TQ getRxg3_QuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(3, rep);
        return retVal;
    }

    public int getRxg3_QuantityTimingReps() {
        return this.getReps(3);
    }

    public TQ insertQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(3, rep);
    }

    public TQ insertRxg3_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(3, rep);
    }

    public TQ removeQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(3, rep);
    }

    public TQ removeRxg3_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(3, rep);
    }

    public CE getGiveCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRxg4_GiveCode() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getRxg5_GiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getRxg6_GiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getGiveUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRxg7_GiveUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getGiveDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getRxg8_GiveDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getAdministrationNotes() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getRxg9_AdministrationNotes() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getRxg10_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public CM_LA1 getDeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_LA1 getRxg11_DeliverToLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getRxg12_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public CE[] getPharmacySpecialAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(13, new CE[0]);
        return retVal;
    }

    public CE[] getRxg13_PharmacySpecialAdministrationInstructions() {
        CE[] retVal = (CE[])this.getTypedField(13, new CE[0]);
        return retVal;
    }

    public int getPharmacySpecialAdministrationInstructionsReps() {
        return this.getReps(13);
    }

    public CE getPharmacySpecialAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(13, rep);
        return retVal;
    }

    public CE getRxg13_PharmacySpecialAdministrationInstructions(int rep) {
        CE retVal = (CE)this.getTypedField(13, rep);
        return retVal;
    }

    public int getRxg13_PharmacySpecialAdministrationInstructionsReps() {
        return this.getReps(13);
    }

    public CE insertPharmacySpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(13, rep);
    }

    public CE insertRxg13_PharmacySpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(13, rep);
    }

    public CE removePharmacySpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(13, rep);
    }

    public CE removeRxg13_PharmacySpecialAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(13, rep);
    }

    public ST getGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getRxg14_GivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getGiveRateAmount() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getRxg15_GiveRateAmount() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getGiveRateUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getRxg16_GiveRateUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new TQ(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 10: {
                return new CM_LA1(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

