/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM5
extends AbstractSegment {
    public OM5(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage()}, "Segment Type ID");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/ Observation Master File");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Tests / observations included within an ordered test battery");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Observation ID Suffixes");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OM5 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getSegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getOm51_SegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOm52_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public CE[] getTestsObservationsIncludedWithinAnOrderedTestBattery() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public CE[] getOm53_TestsObservationsIncludedWithinAnOrderedTestBattery() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public int getTestsObservationsIncludedWithinAnOrderedTestBatteryReps() {
        return this.getReps(3);
    }

    public CE getTestsObservationsIncludedWithinAnOrderedTestBattery(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public CE getOm53_TestsObservationsIncludedWithinAnOrderedTestBattery(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm53_TestsObservationsIncludedWithinAnOrderedTestBatteryReps() {
        return this.getReps(3);
    }

    public CE insertTestsObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE insertOm53_TestsObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE removeTestsObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE removeOm53_TestsObservationsIncludedWithinAnOrderedTestBattery(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public ST getObservationIDSuffixes() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getOm54_ObservationIDSuffixes() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

