/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.persistence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointInfoDTO;
import org.wso2.carbon.inbound.endpoint.persistence.PersistenceUtils;
import org.wso2.carbon.inbound.endpoint.persistence.ServiceReferenceHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;

public class InboundEndpointsDataStore {
    private static final Log log = LogFactory.getLog(InboundEndpointsDataStore.class);
    private Map<Integer, List<InboundEndpointInfoDTO>> endpointListeningInfo;
    private Map<String, Set<String>> endpointPollingInfo;
    private Registry registry;
    private final String rootPath = "/repository/esb/inbound/inbound-endpoints/";
    private static InboundEndpointsDataStore instance = new InboundEndpointsDataStore();

    public static InboundEndpointsDataStore getInstance() {
        return instance;
    }

    private InboundEndpointsDataStore() {
        block10: {
            this.registry = null;
            this.rootPath = "/repository/esb/inbound/inbound-endpoints/";
            try {
                this.registry = ServiceReferenceHolder.getInstance().getRegistry();
            }
            catch (RegistryException e) {
                this.handleException("Error while obtaining a registry instance", (Exception)((Object)e));
            }
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                try {
                    Resource fetchedResource = this.registry.get("/repository/esb/inbound/inbound-endpoints/");
                    if (fetchedResource == null) break block10;
                    String fetchedData = null;
                    if (fetchedResource.getContent() instanceof byte[]) {
                        fetchedData = new String((byte[])fetchedResource.getContent());
                    }
                    OMElement fetchedOM = null;
                    try {
                        fetchedOM = AXIOMUtil.stringToOM(fetchedData);
                    }
                    catch (XMLStreamException e) {
                        this.handleException("Error while converting fetched registry data to a OM", e);
                    }
                    this.endpointListeningInfo = PersistenceUtils.convertOMToEndpointListeningInfo(fetchedOM);
                    this.endpointPollingInfo = PersistenceUtils.convertOMToEndpointPollingInfo(fetchedOM);
                }
                catch (ResourceNotFoundException ex) {
                    log.info((Object)"Inbound endpoint registry data not found, so re-initializing registry data");
                    this.initRegistryData();
                }
                catch (RegistryException e) {
                    this.handleException("Error occurred while fetching inbound endpoint data from registry", (Exception)((Object)e));
                }
            } else {
                this.endpointListeningInfo = new ConcurrentHashMap<Integer, List<InboundEndpointInfoDTO>>();
                this.endpointPollingInfo = new ConcurrentHashMap<String, Set<String>>();
            }
        }
    }

    private void initRegistryData() {
        this.endpointListeningInfo = new ConcurrentHashMap<Integer, List<InboundEndpointInfoDTO>>();
        this.endpointPollingInfo = new ConcurrentHashMap<String, Set<String>>();
        try {
            Resource resource = this.registry.newResource();
            resource.setContent((Object)PersistenceUtils.convertEndpointInfoToOM(this.endpointListeningInfo, this.endpointPollingInfo).toString());
            this.registry.put("/repository/esb/inbound/inbound-endpoints/", resource);
        }
        catch (RegistryException e) {
            this.handleException("Initializing registry data.Error while creating registry resource", (Exception)((Object)e));
        }
    }

    public void registerListeningEndpoint(int port, String tenantDomain, String protocol, String name, InboundProcessorParams params) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port);
        if (tenantList == null) {
            tenantList = new ArrayList<InboundEndpointInfoDTO>();
            this.endpointListeningInfo.put(port -= PersistenceUtils.getPortOffset(params.getProperties()), tenantList);
        }
        tenantList.add(new InboundEndpointInfoDTO(tenantDomain, protocol, name, params));
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.updateRegistry();
        }
    }

    public void registerPollingingEndpoint(String tenantDomain, String name) {
        Set<String> lNames = this.endpointPollingInfo.get(tenantDomain);
        if (lNames == null) {
            lNames = new HashSet<String>();
        }
        lNames.add(name);
        this.endpointPollingInfo.put(tenantDomain, lNames);
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.updateRegistry();
        }
    }

    public void registerSSLListeningEndpoint(int port, String tenantDomain, String protocol, String name, SSLConfiguration sslConfiguration, InboundProcessorParams params) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port);
        if (tenantList == null) {
            tenantList = new ArrayList<InboundEndpointInfoDTO>();
            this.endpointListeningInfo.put(port, tenantList);
        }
        InboundEndpointInfoDTO inboundEndpointInfoDTO = new InboundEndpointInfoDTO(tenantDomain, protocol, name, params);
        inboundEndpointInfoDTO.setSslConfiguration(sslConfiguration);
        tenantList.add(inboundEndpointInfoDTO);
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.updateRegistry();
        }
    }

    public String getListeningEndpointName(int port, String tenantDomain) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port);
        if (tenantList != null) {
            for (InboundEndpointInfoDTO tenantInfo : tenantList) {
                if (!tenantInfo.getTenantDomain().equals(tenantDomain)) continue;
                return tenantInfo.getEndpointName();
            }
        }
        return null;
    }

    public void unregisterListeningEndpoint(int port, String tenantDomain) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port);
        if (tenantList != null) {
            for (InboundEndpointInfoDTO tenantInfo : tenantList) {
                if (!tenantInfo.getTenantDomain().equals(tenantDomain)) continue;
                tenantList.remove(tenantInfo);
                break;
            }
        }
        if (this.endpointListeningInfo.get(port) != null && this.endpointListeningInfo.get(port).size() == 0) {
            this.endpointListeningInfo.remove(port);
        }
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.updateRegistry();
        }
    }

    public void unregisterPollingEndpoint(String tenantDomain, String name) {
        Set<String> lNames = this.endpointPollingInfo.get(tenantDomain);
        if (lNames != null && !lNames.isEmpty()) {
            for (String strName : lNames) {
                if (!strName.equals(name)) continue;
                lNames.remove(strName);
                break;
            }
            if (lNames.isEmpty()) {
                this.endpointPollingInfo.remove(tenantDomain);
            }
        }
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.updateRegistry();
        }
    }

    public boolean isPollingEndpointRegistered(String tenantDomain, String name) {
        Set<String> lNames = this.endpointPollingInfo.get(tenantDomain);
        if (lNames != null && !lNames.isEmpty()) {
            for (String strName : lNames) {
                if (!strName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEndpointRegistryEmpty(int port) {
        return this.endpointListeningInfo.get(port) == null;
    }

    public Map<Integer, List<InboundEndpointInfoDTO>> getAllListeningEndpointData() {
        return this.endpointListeningInfo;
    }

    public Map<String, Set<String>> getAllPollingingEndpointData() {
        return this.endpointPollingInfo;
    }

    private synchronized void updateRegistry() {
        OMElement dataOM = PersistenceUtils.convertEndpointInfoToOM(this.endpointListeningInfo, this.endpointPollingInfo);
        try {
            Resource resource = this.registry.get("/repository/esb/inbound/inbound-endpoints/");
            resource.setContent((Object)dataOM.toString());
            this.registry.put("/repository/esb/inbound/inbound-endpoints/", resource);
        }
        catch (RegistryException e) {
            this.handleException("Exception occurred while updating registry data", (Exception)((Object)e));
        }
    }

    private void handleException(String msg, Exception ex) {
        log.error((Object)msg, (Throwable)ex);
    }
}

