/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.securewebsocket;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.wso2.carbon.inbound.endpoint.persistence.PersistenceUtils;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketListener;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketEndpointManager;

public class InboundSecureWebsocketListener
extends InboundWebsocketListener {
    private static final Log log = LogFactory.getLog(InboundSecureWebsocketListener.class);
    private int port;
    private String name;
    private InboundProcessorParams processorParams;

    public InboundSecureWebsocketListener(InboundProcessorParams params) {
        super(params);
        this.processorParams = params;
        String portParam = params.getProperties().getProperty("inbound.ws.port");
        try {
            this.port = Integer.parseInt(portParam);
        }
        catch (NumberFormatException e) {
            this.handleException("Validation failed for the port parameter " + portParam, e);
        }
        this.name = params.getName();
    }

    @Override
    public void init() {
        int offsetPort = this.port + PersistenceUtils.getPortOffset((Properties)this.processorParams.getProperties());
        WebsocketEndpointManager.getInstance().startSSLEndpoint(offsetPort, this.name, this.processorParams);
    }
}

