/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabbitMQUtils {
    private static final Log log = LogFactory.getLog(RabbitMQUtils.class);

    public static Connection createConnection(ConnectionFactory factory, Address[] addresses) throws IOException {
        Connection connection = null;
        try {
            connection = factory.newConnection(addresses);
        }
        catch (TimeoutException e) {
            log.error((Object)"Error occurred while creating a connection", (Throwable)e);
        }
        return connection;
    }

    public static Map<String, String> getTransportHeaders(AMQP.BasicProperties properties) {
        Map headers;
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties.getCorrelationId() != null) {
            map.put("rabbitmq.message.correlation.id", properties.getCorrelationId());
        }
        if (properties.getMessageId() != null) {
            map.put("rabbitmq.message.id", properties.getMessageId());
        }
        if (properties.getReplyTo() != null) {
            map.put("RABBITMQ_REPLY_TO", properties.getReplyTo());
        }
        if ((headers = properties.getHeaders()) != null && !headers.isEmpty()) {
            for (String headerName : headers.keySet()) {
                String value = headers.get(headerName).toString();
                map.put(headerName, value);
            }
        }
        return map;
    }

    public static boolean isDurableQueue(Map<String, String> properties) {
        return BooleanUtils.toBoolean((Boolean)BooleanUtils.toBooleanObject((String)properties.get("rabbitmq.queue.durable")));
    }

    public static boolean isExclusiveQueue(Map<String, String> properties) {
        return BooleanUtils.toBoolean((Boolean)BooleanUtils.toBooleanObject((String)properties.get("rabbitmq.queue.exclusive")));
    }

    public static boolean isAutoDeleteQueue(Map<String, String> properties) {
        return BooleanUtils.toBoolean((Boolean)BooleanUtils.toBooleanObject((String)properties.get("rabbitmq.queue.auto.delete")));
    }

    public static boolean isDurableExchange(Map<String, String> properties) {
        return BooleanUtils.toBoolean((Boolean)BooleanUtils.toBooleanObject((String)properties.get("rabbitmq.exchange.durable")));
    }

    public static boolean isAutoDeleteExchange(Map<String, String> properties) {
        return BooleanUtils.toBoolean((Boolean)BooleanUtils.toBooleanObject((String)properties.get("rabbitmq.exchange.auto.delete")));
    }

    private static Map<String, Object> setQueueOptionalArguments(Map<String, String> properties) {
        HashMap<String, Object> optionalArgs = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyKey = entry.getKey();
            if (!propertyKey.startsWith("rabbitmq.queue.optional.")) continue;
            String optionalArgName = propertyKey.substring("rabbitmq.queue.optional.".length());
            String optionalArgValue = entry.getValue();
            if ("true".equals(optionalArgValue) || "false".equals(optionalArgValue)) {
                optionalArgs.put(optionalArgName, Boolean.parseBoolean(optionalArgValue));
                continue;
            }
            try {
                optionalArgs.put(optionalArgName, Integer.parseInt(optionalArgValue));
            }
            catch (NumberFormatException e) {
                optionalArgs.put(optionalArgName, optionalArgValue);
            }
        }
        return optionalArgs.size() == 0 ? null : optionalArgs;
    }

    private static Map<String, Object> setExchangeOptionalArguments(Map<String, String> properties) {
        HashMap<String, Object> optionalArgs = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyKey = entry.getKey();
            if (!propertyKey.startsWith("rabbitmq.exchange.optional.")) continue;
            String optionalArgName = propertyKey.substring("rabbitmq.exchange.optional.".length());
            String optionalArgValue = entry.getValue();
            if ("true".equals(optionalArgValue) || "false".equals(optionalArgValue)) {
                optionalArgs.put(optionalArgName, Boolean.parseBoolean(optionalArgValue));
                continue;
            }
            try {
                optionalArgs.put(optionalArgName, Integer.parseInt(optionalArgValue));
            }
            catch (NumberFormatException e) {
                optionalArgs.put(optionalArgName, optionalArgValue);
            }
        }
        return optionalArgs.size() == 0 ? null : optionalArgs;
    }

    public static void declareQueue(Channel channel, String queueName, Map<String, String> properties) throws IOException {
        if (StringUtils.isNotEmpty((String)queueName)) {
            channel.queueDeclare(queueName, RabbitMQUtils.isDurableQueue(properties), RabbitMQUtils.isExclusiveQueue(properties), RabbitMQUtils.isAutoDeleteQueue(properties), RabbitMQUtils.setQueueOptionalArguments(properties));
        }
    }

    public static void declareExchange(Channel channel, String exchangeName, Map<String, String> properties) throws IOException {
        String type = properties.get("rabbitmq.exchange.type");
        String queueName = properties.get("rabbitmq.queue.name");
        String routingKey = properties.get("rabbitmq.queue.routing.key");
        if (StringUtils.isNotEmpty((String)exchangeName)) {
            if (!exchangeName.startsWith("amq.")) {
                if (StringUtils.isNotEmpty((String)type)) {
                    channel.exchangeDeclare(exchangeName, type, RabbitMQUtils.isDurableExchange(properties), RabbitMQUtils.isAutoDeleteExchange(properties), RabbitMQUtils.setExchangeOptionalArguments(properties));
                } else {
                    channel.exchangeDeclare(exchangeName, BuiltinExchangeType.DIRECT, RabbitMQUtils.isDurableExchange(properties), RabbitMQUtils.isAutoDeleteExchange(properties), RabbitMQUtils.setExchangeOptionalArguments(properties));
                }
            }
            if (StringUtils.isNotEmpty((String)queueName) && StringUtils.isNotEmpty((String)routingKey)) {
                channel.queueBind(queueName, exchangeName, routingKey);
            } else if (StringUtils.isNotEmpty((String)queueName) && StringUtils.isEmpty((String)routingKey)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No routing key specified. The queue name is using as the routing key.");
                }
                routingKey = queueName;
                channel.queueBind(queueName, exchangeName, routingKey);
            }
        }
    }

    public static String buildMessage(AMQP.BasicProperties properties, byte[] body, MessageContext msgContext) throws AxisFault {
        int index;
        String type;
        Builder builder;
        String amqpCorrelationID = properties.getCorrelationId();
        if (amqpCorrelationID != null && amqpCorrelationID.length() > 0) {
            msgContext.setProperty("rabbitmq.message.correlation.id", (Object)amqpCorrelationID);
        } else {
            msgContext.setProperty("rabbitmq.message.correlation.id", (Object)properties.getMessageId());
        }
        String contentType = properties.getContentType();
        if (contentType == null) {
            contentType = "text/plain";
        }
        msgContext.setProperty("rabbitmq.message.content.type", (Object)contentType);
        if (properties.getContentEncoding() != null) {
            msgContext.setProperty("rabbitmq.message.content.encoding", (Object)properties.getContentEncoding());
        }
        if ((builder = BuilderUtil.getBuilderFromSelector((String)(type = (index = contentType.indexOf(59)) > 0 ? contentType.substring(0, index) : contentType), (MessageContext)msgContext)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
            }
            builder = new SOAPBuilder();
        }
        String charSetEnc = null;
        try {
            charSetEnc = new ContentType(contentType).getParameter("charset");
        }
        catch (ParseException ex) {
            log.error((Object)"Parse error", (Throwable)ex);
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEnc);
        OMElement documentElement = builder.processDocument((InputStream)new ByteArrayInputStream(body), contentType, msgContext);
        msgContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
        return contentType;
    }
}

