/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.nats;

import io.nats.streaming.Message;
import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.StreamingConnectionFactory;
import io.nats.streaming.Subscription;
import io.nats.streaming.SubscriptionOptions;
import java.io.IOException;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.inbound.endpoint.protocol.nats.CoreListener;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsMessageConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsMessageListener;
import org.wso2.carbon.inbound.endpoint.protocol.nats.management.NatsEndpointManager;

public class StreamingListener
implements NatsMessageListener {
    private static final Log log = LogFactory.getLog((String)StreamingListener.class.getName());
    private String subject;
    private NatsInjectHandler injectHandler;
    private Properties natsProperties;
    private StreamingConnection connection;
    private Subscription subscription;

    public StreamingListener(String subject, NatsInjectHandler injectHandler, Properties natsProperties) {
        this.subject = subject;
        this.injectHandler = injectHandler;
        this.natsProperties = natsProperties;
    }

    @Override
    public boolean createConnection() throws IOException, InterruptedException {
        if (this.connection == null) {
            String natsStreamingUrl = this.natsProperties.getProperty("nats.streaming.url");
            String natsStreamingClientId = this.natsProperties.getProperty("nats.streaming.client.id");
            String natsStreamingClusterId = this.natsProperties.getProperty("nats.streaming.cluster.id");
            String connectWait = this.natsProperties.getProperty("nats.streaming.connect.wait");
            String discoverPrefix = this.natsProperties.getProperty("nats.streaming.discover.prefix");
            String maxPingsOut = this.natsProperties.getProperty("nats.streaming.max.pings.out");
            String pingInterval = this.natsProperties.getProperty("nats.streaming.ping.interval");
            String traceConnection = this.natsProperties.getProperty("nats.streaming.trace.connection");
            Options.Builder builder = new Options.Builder().natsUrl(StringUtils.isEmpty((String)natsStreamingUrl) ? "nats://localhost:4222" : natsStreamingUrl).clientId(natsStreamingClientId).clusterId(StringUtils.isEmpty((String)natsStreamingClusterId) ? "test-cluster" : natsStreamingClusterId).connectionLostHandler((streamingConnection, e) -> {
                NatsMessageConsumer messageConsumer = NatsEndpointManager.getInstance().getMessageConsumer();
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    this.connection = null;
                    this.subscription = null;
                    messageConsumer.initializeConsumer();
                }
                catch (IOException | InterruptedException ex) {
                    log.error((Object)("An error occurred while connecting to NATS server, consuming messages or while closing the connection. " + ex));
                    messageConsumer.closeConnection();
                }
                catch (SynapseException ex) {
                    log.error((Object)("Error while retrieving or injecting NATS message. " + e.getMessage()), (Throwable)ex);
                }
                catch (Exception ex) {
                    log.error((Object)("Error while retrieving or injecting NATS message or closing conection. " + e.getMessage()), (Throwable)ex);
                    messageConsumer.closeConnection();
                }
            });
            if (Boolean.parseBoolean(this.natsProperties.getProperty("use.core.nats.connection"))) {
                builder.natsConn(new CoreListener(this.subject, this.injectHandler, this.natsProperties).getNatsConnection());
            }
            if (StringUtils.isNotEmpty((String)connectWait)) {
                builder.connectWait(Duration.ofSeconds(Integer.parseInt(connectWait)));
            }
            if (StringUtils.isNotEmpty((String)discoverPrefix)) {
                builder.discoverPrefix(discoverPrefix);
            }
            if (StringUtils.isNotEmpty((String)maxPingsOut)) {
                builder.maxPingsOut(Integer.parseInt(maxPingsOut));
            }
            if (StringUtils.isNotEmpty((String)pingInterval)) {
                builder.pingInterval(Duration.ofSeconds(Integer.parseInt(pingInterval)));
            }
            if (Boolean.parseBoolean(traceConnection)) {
                builder.traceConnection();
            }
            StreamingConnectionFactory connectionFactory = new StreamingConnectionFactory(builder.build());
            this.connection = connectionFactory.createConnection();
        }
        return true;
    }

    @Override
    public void initializeConsumer(String sequenceName) throws InterruptedException, IOException, TimeoutException {
        if (this.createConnection()) {
            SubscriptionOptions.Builder subscriptionOptions = new SubscriptionOptions.Builder();
            String durableName = this.natsProperties.getProperty("nats.streaming.durable.name");
            String queueGroup = this.natsProperties.getProperty("nats.streaming.queue.group");
            boolean isManualAck = Boolean.parseBoolean(this.natsProperties.getProperty("nats.streaming.manual.ack"));
            String ackWait = this.natsProperties.getProperty("nats.streaming.ack.wait");
            String maxInFlight = this.natsProperties.getProperty("nats.streaming.max.in.flight");
            String subscriptionTimeout = this.natsProperties.getProperty("nats.streaming.subscription.timeout");
            String dispatcher = this.natsProperties.getProperty("nats.streaming.dispatcher");
            if (StringUtils.isNotEmpty((String)durableName)) {
                subscriptionOptions.durableName(durableName);
            }
            if (isManualAck) {
                subscriptionOptions.manualAcks();
            }
            if (StringUtils.isNotEmpty((String)ackWait)) {
                subscriptionOptions.ackWait(Duration.ofSeconds(Integer.parseInt(ackWait)));
            }
            if (StringUtils.isNotEmpty((String)maxInFlight)) {
                subscriptionOptions.maxInFlight(Integer.parseInt(maxInFlight));
            }
            if (StringUtils.isNotEmpty((String)subscriptionTimeout)) {
                subscriptionOptions.subscriptionTimeout(Duration.ofSeconds(Integer.parseInt(subscriptionTimeout)));
            }
            if (StringUtils.isNotEmpty((String)dispatcher)) {
                subscriptionOptions.dispatcher(dispatcher);
            }
            this.subscription = this.connection.subscribe(this.subject, queueGroup, natsMessage -> {
                boolean isInjected;
                String message = new String(natsMessage.getData());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message Received to NATS Inbound EP: " + message));
                }
                if (isInjected = this.injectHandler.invoke(message.getBytes(), sequenceName, null, null)) {
                    this.acknowledge(isManualAck, natsMessage);
                }
            }, subscriptionOptions.build());
        }
    }

    private void acknowledge(boolean isManualAck, Message natsMessage) {
        if (isManualAck) {
            try {
                natsMessage.ack();
            }
            catch (IOException e) {
                log.error((Object)("An error occurred while sending manual ack. Message might get redelivered. Sequence number: " + natsMessage.getSequence()), (Throwable)e);
            }
        }
    }

    @Override
    public void closeConnection() {
        try {
            if (this.subscription != null) {
                this.subscription.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            log.error((Object)"An error occurred while closing the connection. ", (Throwable)e);
        }
        this.connection = null;
        this.subscription = null;
    }
}

