/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.mqtt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionConsumer;

public class MqttConnectionListener {
    private static final Log log = LogFactory.getLog(MqttConnectionListener.class);
    private MqttConnectionConsumer mqttConnectionConsumer;
    private boolean execute = true;
    private static final int DEFAULT_RECONNECTION_INTERVAL = 10000;

    public MqttConnectionListener(MqttConnectionConsumer mqttConnectionConsumer) {
        this.mqttConnectionConsumer = mqttConnectionConsumer;
    }

    public void onFailure() {
        try {
            int retryInterval = this.mqttConnectionConsumer.getMqttConnectionFactory().getReconnectionInterval();
            boolean isConnected = false;
            int retryCount = 1;
            while (this.execute && !isConnected) {
                if (retryInterval != -1) {
                    Thread.sleep(retryInterval);
                } else {
                    Thread.sleep(10000L);
                }
                try {
                    IMqttToken connectionToken = this.mqttConnectionConsumer.getMqttAsyncClient().connect(this.mqttConnectionConsumer.getConnectOptions());
                    connectionToken.waitForCompletion();
                    if (!this.mqttConnectionConsumer.getMqttAsyncClient().isConnected()) continue;
                    isConnected = true;
                    log.info((Object)("Successfully reconnected MQTT inbound endpoint: " + this.mqttConnectionConsumer.getName()));
                }
                catch (MqttException ex) {
                    log.error((Object)("MQTT inbound endpoint " + this.mqttConnectionConsumer.getName() + " error while reconnecting to the broker attempt " + retryCount++));
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            log.error((Object)"Error while trying to subscribe to the remote", (Throwable)ex);
        }
    }

    public void shutdown() {
        this.execute = false;
    }
}

