/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.mqtt;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionFactory;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttConnectionListener;

public class MqttConnectionConsumer {
    private static final Log log = LogFactory.getLog(MqttConnectionConsumer.class);
    private MqttAsyncClient mqttAsyncClient;
    private MqttConnectOptions connectOptions;
    private MqttConnectionFactory confac;
    private Properties mqttProperties;
    private MqttConnectionListener connectionListener;
    private String name;

    public MqttConnectionConsumer(MqttConnectOptions connectOptions, MqttAsyncClient mqttAsyncClient, MqttConnectionFactory confac, Properties mqttProperties, String name) {
        this.name = name;
        this.connectOptions = connectOptions;
        this.mqttAsyncClient = mqttAsyncClient;
        this.confac = confac;
        this.mqttProperties = mqttProperties;
    }

    public void execute() {
        if (this.mqttAsyncClient != null) {
            if (this.mqttAsyncClient.isConnected()) {
                return;
            }
            try {
                this.connectionListener = new MqttConnectionListener(this);
                IMqttToken token = this.mqttAsyncClient.connect(this.connectOptions);
                token.waitForCompletion();
                if (!this.mqttAsyncClient.isConnected()) {
                    this.connectionListener.onFailure();
                }
                if (this.mqttAsyncClient.isConnected()) {
                    int qosLevel = Integer.parseInt(this.mqttProperties.getProperty("mqtt.subscription.qos"));
                    if (this.confac.getTopic() != null) {
                        this.mqttAsyncClient.subscribe(this.confac.getTopic(), qosLevel);
                    }
                    log.info((Object)("MQTT inbound endpoint " + this.name + " connected to the broker"));
                }
            }
            catch (MqttException ex) {
                log.error((Object)"Error while trying to subscribe to the remote ", (Throwable)ex);
                this.connectionListener.onFailure();
            }
        }
    }

    public void shutdown() {
        if (this.connectionListener != null) {
            this.connectionListener.shutdown();
        }
    }

    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public MqttAsyncClient getMqttAsyncClient() {
        return this.mqttAsyncClient;
    }

    public MqttConnectionFactory getMqttConnectionFactory() {
        return this.confac;
    }

    public Properties getMqttProperties() {
        return this.mqttProperties;
    }

    public String getName() {
        return this.name;
    }
}

