/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.jms;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import javax.activation.DataHandler;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundResponseSender;
import org.wso2.carbon.inbound.endpoint.protocol.jms.BytesMessageOutputStream;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSConstants;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSUtils;
import org.wso2.carbon.inbound.endpoint.protocol.jms.factory.CachedJMSConnectionFactory;

public class JMSReplySender
implements InboundResponseSender {
    private static final Log log = LogFactory.getLog((String)JMSReplySender.class.getName());
    private Destination replyTo;
    private CachedJMSConnectionFactory cachedJMSConnectionFactory;
    private String strUserName;
    private String strPassword;

    public JMSReplySender(Destination replyTo, CachedJMSConnectionFactory cachedJMSConnectionFactory, String strUserName, String strPassword) {
        this.replyTo = replyTo;
        this.strUserName = strUserName;
        this.strPassword = strPassword;
        this.cachedJMSConnectionFactory = cachedJMSConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBack(org.apache.synapse.MessageContext synCtx) {
        log.debug((Object)"Begin sending reply to the destination queue.");
        MessageProducer producer = null;
        Session session = null;
        try {
            Connection connection = this.cachedJMSConnectionFactory.getConnection(this.strUserName, this.strPassword);
            session = this.cachedJMSConnectionFactory.getSession(connection);
            producer = this.cachedJMSConnectionFactory.createProducer(session, this.replyTo, true);
            Message message = this.createJMSMessage(synCtx, session, null);
            producer.send(message);
        }
        catch (JMSException e) {
            log.error((Object)"Error sending JMS response", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error sending JMS response", (Throwable)e);
        }
        finally {
            try {
                producer.close();
            }
            catch (Exception e) {
                log.debug((Object)"ERROR: Unable to close the producer");
            }
            try {
                session.close();
            }
            catch (Exception e) {
                log.debug((Object)"ERROR: Unable to close the session");
            }
        }
    }

    private Message createJMSMessage(org.apache.synapse.MessageContext synCtx, Session session, String contentTypeProperty) throws JMSException {
        BytesMessage message = null;
        MessageContext msgContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String msgType = this.getProperty(msgContext, "JMS_MESSAGE_TYPE");
        String jmsPayloadType = this.guessMessageType(msgContext);
        if (jmsPayloadType == null) {
            BytesMessageOutputStream out;
            StringWriter sw;
            boolean useBytesMessage;
            OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
            MessageFormatter messageFormatter = null;
            try {
                messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
            }
            catch (AxisFault axisFault) {
                throw new JMSException("Unable to get the message formatter to use");
            }
            String contentType = messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction());
            boolean bl = useBytesMessage = msgType != null && "JMS_BYTE_MESSAGE".equals(msgType) || contentType.indexOf("multipart/related") > -1;
            if (useBytesMessage) {
                BytesMessage bytesMsg = session.createBytesMessage();
                sw = null;
                out = new BytesMessageOutputStream(bytesMsg);
                message = bytesMsg;
            } else {
                sw = new StringWriter();
                try {
                    out = new WriterOutputStream((Writer)sw, format.getCharSetEncoding());
                }
                catch (UnsupportedCharsetException ex) {
                    log.error((Object)("Unsupported encoding " + format.getCharSetEncoding()), (Throwable)ex);
                    throw new JMSException("Unsupported encoding " + format.getCharSetEncoding());
                }
            }
            try {
                messageFormatter.writeTo(msgContext, format, (OutputStream)out, true);
                out.close();
            }
            catch (IOException e) {
                log.error((Object)"IO Error while creating BytesMessage", (Throwable)e);
                throw new JMSException("IO Error while creating BytesMessage");
            }
            if (!useBytesMessage) {
                TextMessage txtMsg = session.createTextMessage();
                txtMsg.setText(sw.toString());
                message = txtMsg;
            }
            if (contentTypeProperty != null) {
                message.setStringProperty(contentTypeProperty, contentType);
            }
        } else if ("JMS_BYTE_MESSAGE".equals(jmsPayloadType)) {
            Object dh;
            BytesMessage bytesMsg = message = session.createBytesMessage();
            OMElement wrapper = msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_BINARY_WRAPPER);
            OMNode omNode = wrapper.getFirstOMChild();
            if (omNode != null && omNode instanceof OMText && (dh = ((OMText)omNode).getDataHandler()) != null && dh instanceof DataHandler) {
                try {
                    ((DataHandler)dh).writeTo((OutputStream)new BytesMessageOutputStream(bytesMsg));
                }
                catch (IOException e) {
                    log.error((Object)("Error serializing binary content of element : " + BaseConstants.DEFAULT_BINARY_WRAPPER), (Throwable)e);
                    throw new JMSException("Error serializing binary content of element : " + BaseConstants.DEFAULT_BINARY_WRAPPER);
                }
            }
        } else if ("JMS_TEXT_MESSAGE".equals(jmsPayloadType)) {
            message = session.createTextMessage();
            TextMessage txtMsg = (TextMessage)message;
            txtMsg.setText(msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_TEXT_WRAPPER).getText());
        } else if ("JMS_MAP_MESSAGE".equalsIgnoreCase(jmsPayloadType)) {
            message = session.createMapMessage();
            JMSUtils.convertXMLtoJMSMap(msgContext.getEnvelope().getBody().getFirstChildWithName(JMSConstants.JMS_MAP_QNAME), (MapMessage)message);
        }
        String correlationId = (String)synCtx.getProperty("JMS_COORELATION_ID");
        if (correlationId != null) {
            message.setJMSCorrelationID(correlationId);
        }
        if (msgContext.isServerSide()) {
            this.setProperty((Message)message, msgContext, "SOAPAction");
        } else {
            String action = msgContext.getOptions().getAction();
            if (action != null) {
                message.setStringProperty("SOAPAction", action);
            }
        }
        JMSUtils.setTransportHeaders(msgContext, (Message)message);
        return message;
    }

    private void setProperty(Message message, MessageContext msgCtx, String key) {
        String value = this.getProperty(msgCtx, key);
        if (value != null) {
            try {
                message.setStringProperty(key, value);
            }
            catch (JMSException e) {
                log.warn((Object)("Couldn't set message property : " + key + " = " + value), (Throwable)e);
            }
        }
    }

    private String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }

    private String guessMessageType(MessageContext msgContext) {
        OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
        if (firstChild != null) {
            if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_BYTE_MESSAGE";
            }
            if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_TEXT_MESSAGE";
            }
            if (JMSConstants.JMS_MAP_QNAME.equals(firstChild.getQName())) {
                return "JMS_MAP_MESSAGE";
            }
        }
        return null;
    }
}

