/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.Severity;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuleSupport<T>
implements Rule<T> {
    private static final ValidationException[] PASSED = new ValidationException[0];
    private Severity severity = Severity.ERROR;
    private String description;
    private String sectionReference;
    private ErrorCode errorCode = ErrorCode.APPLICATION_INTERNAL_ERROR;

    protected ValidationException[] result(boolean result, Object value) {
        return this.result(result, value, Location.UNKNOWN);
    }

    protected ValidationException[] result(boolean result, Object value, Location location) {
        return result ? this.passed() : this.failedWithValue(value, location);
    }

    protected ValidationException[] passed() {
        return PASSED;
    }

    protected ValidationException[] failedWithValue(Object value, Location location) {
        String description = this.getDescription();
        String msg = String.format(description, String.valueOf(value));
        return this.failed("Validation failed: " + msg, location);
    }

    protected ValidationException[] failed(String msg) {
        return this.failed(msg, Location.UNKNOWN);
    }

    protected ValidationException[] failed(String msg, Location location) {
        ValidationException ve = new ValidationException(msg, this.severity);
        ve.setError(this.getErrorCode());
        ve.setLocation(location);
        return new ValidationException[]{ve};
    }

    protected ValidationException[] failed(Exception e) {
        return this.failed(e, Location.UNKNOWN);
    }

    protected ValidationException[] failed(Exception e, Location location) {
        if (e instanceof ValidationException) {
            return new ValidationException[]{(ValidationException)e};
        }
        ValidationException ve = new ValidationException(e.getMessage(), e, this.severity);
        ve.setError(this.getErrorCode());
        ve.setLocation(location);
        return new ValidationException[]{ve};
    }

    @Override
    public String getSectionReference() {
        return this.sectionReference;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public ErrorCode getErrorCode() {
        return ErrorCode.APPLICATION_INTERNAL_ERROR;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSectionReference(String sectionReference) {
        this.sectionReference = sectionReference;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }
}

