/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.segment.CER;
import ca.uhn.hl7v2.model.v26.segment.EVN;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PRA;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.STF;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMU_B08
extends AbstractMessage {
    public PMU_B08() {
        this(new DefaultModelClassFactory());
    }

    public PMU_B08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(STF.class, true, false);
            this.add(PRA.class, false, false);
            this.add(CER.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PMU_B08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public STF getSTF() {
        return this.getTyped("STF", STF.class);
    }

    public PRA getPRA() {
        return this.getTyped("PRA", PRA.class);
    }

    public CER getCER() {
        return this.getTyped("CER", CER.class);
    }

    public CER getCER(int rep) {
        return this.getTyped("CER", rep, CER.class);
    }

    public int getCERReps() {
        return this.getReps("CER");
    }

    public List<CER> getCERAll() throws HL7Exception {
        return this.getAllAsList("CER", CER.class);
    }

    public void insertCER(CER structure, int rep) throws HL7Exception {
        super.insertRepetition("CER", structure, rep);
    }

    public CER insertCER(int rep) throws HL7Exception {
        return (CER)super.insertRepetition("CER", rep);
    }

    public CER removeCER(int rep) throws HL7Exception {
        return (CER)super.removeRepetition("CER", rep);
    }
}

