/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.QSC;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class VTQ
extends AbstractSegment {
    public VTQ(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 32, new Object[]{this.getMessage()}, "Query Tag");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(106)}, "Query/Response Format Code");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "VT Query Name");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Virtual Table Name");
            this.add(QSC.class, false, 0, 256, new Object[]{this.getMessage()}, "Selection Criteria");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating VTQ - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getQueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getVtq1_QueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getQueryResponseFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getVtq2_QueryResponseFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getVTQueryName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getVtq3_VTQueryName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getVirtualTableName() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getVtq4_VirtualTableName() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public QSC[] getSelectionCriteria() {
        QSC[] retVal = (QSC[])this.getTypedField(5, new QSC[0]);
        return retVal;
    }

    public QSC[] getVtq5_SelectionCriteria() {
        QSC[] retVal = (QSC[])this.getTypedField(5, new QSC[0]);
        return retVal;
    }

    public int getSelectionCriteriaReps() {
        return this.getReps(5);
    }

    public QSC getSelectionCriteria(int rep) {
        QSC retVal = (QSC)this.getTypedField(5, rep);
        return retVal;
    }

    public QSC getVtq5_SelectionCriteria(int rep) {
        QSC retVal = (QSC)this.getTypedField(5, rep);
        return retVal;
    }

    public int getVtq5_SelectionCriteriaReps() {
        return this.getReps(5);
    }

    public QSC insertSelectionCriteria(int rep) throws HL7Exception {
        return (QSC)super.insertRepetition(5, rep);
    }

    public QSC insertVtq5_SelectionCriteria(int rep) throws HL7Exception {
        return (QSC)super.insertRepetition(5, rep);
    }

    public QSC removeSelectionCriteria(int rep) throws HL7Exception {
        return (QSC)super.removeRepetition(5, rep);
    }

    public QSC removeVtq5_SelectionCriteria(int rep) throws HL7Exception {
        return (QSC)super.removeRepetition(5, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(106));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new QSC(this.getMessage());
            }
        }
        return null;
    }
}

