/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.NA;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.SN;
import ca.uhn.hl7v2.model.v251.datatype.SPS;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SAC
extends AbstractSegment {
    public SAC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "External Accession Identifier");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Accession Identifier");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Container Identifier");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Primary (parent) Container Identifier");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Equipment Container Identifier");
            this.add(SPS.class, false, 1, 300, new Object[]{this.getMessage()}, "Specimen Source");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Registration Date/Time");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Container Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Carrier Type");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Carrier Identifier");
            this.add(NA.class, false, 1, 80, new Object[]{this.getMessage()}, "Position in Carrier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Tray Type - SAC");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Tray Identifier");
            this.add(NA.class, false, 1, 80, new Object[]{this.getMessage()}, "Position in Tray");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Location");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Container Height");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Container Diameter");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Barrier Delta");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Bottom Delta");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Container Height/Diameter/Delta Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Container Volume");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Available Specimen Volume");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Initial Specimen Volume");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Volume Units");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Separator Type");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Cap Type");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Additive");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Specimen Component");
            this.add(SN.class, false, 1, 20, new Object[]{this.getMessage()}, "Dilution Factor");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Treatment");
            this.add(SN.class, false, 1, 20, new Object[]{this.getMessage()}, "Temperature");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Hemolysis Index");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Hemolysis Index Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Lipemia Index");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Lipemia Index Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Icterus Index");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Icterus Index Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Fibrin Index");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Fibrin Index Units");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "System Induced Contaminants");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Drug Interference");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Artificial Blood");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Special Handling Code");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Other Environmental Factors");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SAC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getExternalAccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getSac1_ExternalAccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getAccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSac2_AccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getContainerIdentifier() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getSac3_ContainerIdentifier() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getPrimaryParentContainerIdentifier() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getSac4_PrimaryParentContainerIdentifier() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getEquipmentContainerIdentifier() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getSac5_EquipmentContainerIdentifier() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public SPS getSpecimenSource() {
        SPS retVal = (SPS)this.getTypedField(6, 0);
        return retVal;
    }

    public SPS getSac6_SpecimenSource() {
        SPS retVal = (SPS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getRegistrationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getSac7_RegistrationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getContainerStatus() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getSac8_ContainerStatus() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getCarrierType() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getSac9_CarrierType() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public EI getCarrierIdentifier() {
        EI retVal = (EI)this.getTypedField(10, 0);
        return retVal;
    }

    public EI getSac10_CarrierIdentifier() {
        EI retVal = (EI)this.getTypedField(10, 0);
        return retVal;
    }

    public NA getPositionInCarrier() {
        NA retVal = (NA)this.getTypedField(11, 0);
        return retVal;
    }

    public NA getSac11_PositionInCarrier() {
        NA retVal = (NA)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getTrayTypeSAC() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getSac12_TrayTypeSAC() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public EI getTrayIdentifier() {
        EI retVal = (EI)this.getTypedField(13, 0);
        return retVal;
    }

    public EI getSac13_TrayIdentifier() {
        EI retVal = (EI)this.getTypedField(13, 0);
        return retVal;
    }

    public NA getPositionInTray() {
        NA retVal = (NA)this.getTypedField(14, 0);
        return retVal;
    }

    public NA getSac14_PositionInTray() {
        NA retVal = (NA)this.getTypedField(14, 0);
        return retVal;
    }

    public CE[] getLocation() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public CE[] getSac15_Location() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public int getLocationReps() {
        return this.getReps(15);
    }

    public CE getLocation(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public CE getSac15_Location(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getSac15_LocationReps() {
        return this.getReps(15);
    }

    public CE insertLocation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE insertSac15_Location(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE removeLocation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public CE removeSac15_Location(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public NM getContainerHeight() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getSac16_ContainerHeight() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getContainerDiameter() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getSac17_ContainerDiameter() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getBarrierDelta() {
        NM retVal = (NM)this.getTypedField(18, 0);
        return retVal;
    }

    public NM getSac18_BarrierDelta() {
        NM retVal = (NM)this.getTypedField(18, 0);
        return retVal;
    }

    public NM getBottomDelta() {
        NM retVal = (NM)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getSac19_BottomDelta() {
        NM retVal = (NM)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getContainerHeightDiameterDeltaUnits() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public CE getSac20_ContainerHeightDiameterDeltaUnits() {
        CE retVal = (CE)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getContainerVolume() {
        NM retVal = (NM)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getSac21_ContainerVolume() {
        NM retVal = (NM)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getAvailableSpecimenVolume() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getSac22_AvailableSpecimenVolume() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getInitialSpecimenVolume() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getSac23_InitialSpecimenVolume() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public CE getVolumeUnits() {
        CE retVal = (CE)this.getTypedField(24, 0);
        return retVal;
    }

    public CE getSac24_VolumeUnits() {
        CE retVal = (CE)this.getTypedField(24, 0);
        return retVal;
    }

    public CE getSeparatorType() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getSac25_SeparatorType() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getCapType() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CE getSac26_CapType() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE[] getAdditive() {
        CWE[] retVal = (CWE[])this.getTypedField(27, new CWE[0]);
        return retVal;
    }

    public CWE[] getSac27_Additive() {
        CWE[] retVal = (CWE[])this.getTypedField(27, new CWE[0]);
        return retVal;
    }

    public int getAdditiveReps() {
        return this.getReps(27);
    }

    public CWE getAdditive(int rep) {
        CWE retVal = (CWE)this.getTypedField(27, rep);
        return retVal;
    }

    public CWE getSac27_Additive(int rep) {
        CWE retVal = (CWE)this.getTypedField(27, rep);
        return retVal;
    }

    public int getSac27_AdditiveReps() {
        return this.getReps(27);
    }

    public CWE insertAdditive(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(27, rep);
    }

    public CWE insertSac27_Additive(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(27, rep);
    }

    public CWE removeAdditive(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(27, rep);
    }

    public CWE removeSac27_Additive(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(27, rep);
    }

    public CE getSpecimenComponent() {
        CE retVal = (CE)this.getTypedField(28, 0);
        return retVal;
    }

    public CE getSac28_SpecimenComponent() {
        CE retVal = (CE)this.getTypedField(28, 0);
        return retVal;
    }

    public SN getDilutionFactor() {
        SN retVal = (SN)this.getTypedField(29, 0);
        return retVal;
    }

    public SN getSac29_DilutionFactor() {
        SN retVal = (SN)this.getTypedField(29, 0);
        return retVal;
    }

    public CE getTreatment() {
        CE retVal = (CE)this.getTypedField(30, 0);
        return retVal;
    }

    public CE getSac30_Treatment() {
        CE retVal = (CE)this.getTypedField(30, 0);
        return retVal;
    }

    public SN getTemperature() {
        SN retVal = (SN)this.getTypedField(31, 0);
        return retVal;
    }

    public SN getSac31_Temperature() {
        SN retVal = (SN)this.getTypedField(31, 0);
        return retVal;
    }

    public NM getHemolysisIndex() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getSac32_HemolysisIndex() {
        NM retVal = (NM)this.getTypedField(32, 0);
        return retVal;
    }

    public CE getHemolysisIndexUnits() {
        CE retVal = (CE)this.getTypedField(33, 0);
        return retVal;
    }

    public CE getSac33_HemolysisIndexUnits() {
        CE retVal = (CE)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getLipemiaIndex() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public NM getSac34_LipemiaIndex() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public CE getLipemiaIndexUnits() {
        CE retVal = (CE)this.getTypedField(35, 0);
        return retVal;
    }

    public CE getSac35_LipemiaIndexUnits() {
        CE retVal = (CE)this.getTypedField(35, 0);
        return retVal;
    }

    public NM getIcterusIndex() {
        NM retVal = (NM)this.getTypedField(36, 0);
        return retVal;
    }

    public NM getSac36_IcterusIndex() {
        NM retVal = (NM)this.getTypedField(36, 0);
        return retVal;
    }

    public CE getIcterusIndexUnits() {
        CE retVal = (CE)this.getTypedField(37, 0);
        return retVal;
    }

    public CE getSac37_IcterusIndexUnits() {
        CE retVal = (CE)this.getTypedField(37, 0);
        return retVal;
    }

    public NM getFibrinIndex() {
        NM retVal = (NM)this.getTypedField(38, 0);
        return retVal;
    }

    public NM getSac38_FibrinIndex() {
        NM retVal = (NM)this.getTypedField(38, 0);
        return retVal;
    }

    public CE getFibrinIndexUnits() {
        CE retVal = (CE)this.getTypedField(39, 0);
        return retVal;
    }

    public CE getSac39_FibrinIndexUnits() {
        CE retVal = (CE)this.getTypedField(39, 0);
        return retVal;
    }

    public CE[] getSystemInducedContaminants() {
        CE[] retVal = (CE[])this.getTypedField(40, new CE[0]);
        return retVal;
    }

    public CE[] getSac40_SystemInducedContaminants() {
        CE[] retVal = (CE[])this.getTypedField(40, new CE[0]);
        return retVal;
    }

    public int getSystemInducedContaminantsReps() {
        return this.getReps(40);
    }

    public CE getSystemInducedContaminants(int rep) {
        CE retVal = (CE)this.getTypedField(40, rep);
        return retVal;
    }

    public CE getSac40_SystemInducedContaminants(int rep) {
        CE retVal = (CE)this.getTypedField(40, rep);
        return retVal;
    }

    public int getSac40_SystemInducedContaminantsReps() {
        return this.getReps(40);
    }

    public CE insertSystemInducedContaminants(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(40, rep);
    }

    public CE insertSac40_SystemInducedContaminants(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(40, rep);
    }

    public CE removeSystemInducedContaminants(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(40, rep);
    }

    public CE removeSac40_SystemInducedContaminants(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(40, rep);
    }

    public CE[] getDrugInterference() {
        CE[] retVal = (CE[])this.getTypedField(41, new CE[0]);
        return retVal;
    }

    public CE[] getSac41_DrugInterference() {
        CE[] retVal = (CE[])this.getTypedField(41, new CE[0]);
        return retVal;
    }

    public int getDrugInterferenceReps() {
        return this.getReps(41);
    }

    public CE getDrugInterference(int rep) {
        CE retVal = (CE)this.getTypedField(41, rep);
        return retVal;
    }

    public CE getSac41_DrugInterference(int rep) {
        CE retVal = (CE)this.getTypedField(41, rep);
        return retVal;
    }

    public int getSac41_DrugInterferenceReps() {
        return this.getReps(41);
    }

    public CE insertDrugInterference(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(41, rep);
    }

    public CE insertSac41_DrugInterference(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(41, rep);
    }

    public CE removeDrugInterference(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(41, rep);
    }

    public CE removeSac41_DrugInterference(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(41, rep);
    }

    public CE getArtificialBlood() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public CE getSac42_ArtificialBlood() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public CWE[] getSpecialHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(43, new CWE[0]);
        return retVal;
    }

    public CWE[] getSac43_SpecialHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(43, new CWE[0]);
        return retVal;
    }

    public int getSpecialHandlingCodeReps() {
        return this.getReps(43);
    }

    public CWE getSpecialHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(43, rep);
        return retVal;
    }

    public CWE getSac43_SpecialHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(43, rep);
        return retVal;
    }

    public int getSac43_SpecialHandlingCodeReps() {
        return this.getReps(43);
    }

    public CWE insertSpecialHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(43, rep);
    }

    public CWE insertSac43_SpecialHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(43, rep);
    }

    public CWE removeSpecialHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(43, rep);
    }

    public CWE removeSac43_SpecialHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(43, rep);
    }

    public CE[] getOtherEnvironmentalFactors() {
        CE[] retVal = (CE[])this.getTypedField(44, new CE[0]);
        return retVal;
    }

    public CE[] getSac44_OtherEnvironmentalFactors() {
        CE[] retVal = (CE[])this.getTypedField(44, new CE[0]);
        return retVal;
    }

    public int getOtherEnvironmentalFactorsReps() {
        return this.getReps(44);
    }

    public CE getOtherEnvironmentalFactors(int rep) {
        CE retVal = (CE)this.getTypedField(44, rep);
        return retVal;
    }

    public CE getSac44_OtherEnvironmentalFactors(int rep) {
        CE retVal = (CE)this.getTypedField(44, rep);
        return retVal;
    }

    public int getSac44_OtherEnvironmentalFactorsReps() {
        return this.getReps(44);
    }

    public CE insertOtherEnvironmentalFactors(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(44, rep);
    }

    public CE insertSac44_OtherEnvironmentalFactors(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(44, rep);
    }

    public CE removeOtherEnvironmentalFactors(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(44, rep);
    }

    public CE removeSac44_OtherEnvironmentalFactors(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(44, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new SPS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new EI(this.getMessage());
            }
            case 10: {
                return new NA(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new EI(this.getMessage());
            }
            case 13: {
                return new NA(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new NM(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new NM(this.getMessage());
            }
            case 18: {
                return new NM(this.getMessage());
            }
            case 19: {
                return new CE(this.getMessage());
            }
            case 20: {
                return new NM(this.getMessage());
            }
            case 21: {
                return new NM(this.getMessage());
            }
            case 22: {
                return new NM(this.getMessage());
            }
            case 23: {
                return new CE(this.getMessage());
            }
            case 24: {
                return new CE(this.getMessage());
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new CE(this.getMessage());
            }
            case 28: {
                return new SN(this.getMessage());
            }
            case 29: {
                return new CE(this.getMessage());
            }
            case 30: {
                return new SN(this.getMessage());
            }
            case 31: {
                return new NM(this.getMessage());
            }
            case 32: {
                return new CE(this.getMessage());
            }
            case 33: {
                return new NM(this.getMessage());
            }
            case 34: {
                return new CE(this.getMessage());
            }
            case 35: {
                return new NM(this.getMessage());
            }
            case 36: {
                return new CE(this.getMessage());
            }
            case 37: {
                return new NM(this.getMessage());
            }
            case 38: {
                return new CE(this.getMessage());
            }
            case 39: {
                return new CE(this.getMessage());
            }
            case 40: {
                return new CE(this.getMessage());
            }
            case 41: {
                return new CE(this.getMessage());
            }
            case 42: {
                return new CWE(this.getMessage());
            }
            case 43: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

