/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EQU
extends AbstractSegment {
    public EQU(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 22, new Object[]{this.getMessage()}, "Equipment Instance Identifier");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Event Date/Time");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Equipment State");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Local/Remote Control State");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Alert Level");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating EQU - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getEquipmentInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getEqu1_EquipmentInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getEventDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getEqu2_EventDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getEquipmentState() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getEqu3_EquipmentState() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getLocalRemoteControlState() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getEqu4_LocalRemoteControlState() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAlertLevel() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getEqu5_AlertLevel() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

