/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT;
import ca.uhn.hl7v2.model.v251.segment.ERR;
import ca.uhn.hl7v2.model.v251.segment.MSA;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.QRD;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMR_N01
extends AbstractMessage {
    public NMR_N01() {
        this(new DefaultModelClassFactory());
    }

    public NMR_N01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(QRD.class, false, false);
            this.add(NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating NMR_N01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT getCLOCK_AND_STATS_WITH_NOTES_ALT() {
        return this.getTyped("CLOCK_AND_STATS_WITH_NOTES_ALT", NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT.class);
    }

    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT getCLOCK_AND_STATS_WITH_NOTES_ALT(int rep) {
        return this.getTyped("CLOCK_AND_STATS_WITH_NOTES_ALT", rep, NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT.class);
    }

    public int getCLOCK_AND_STATS_WITH_NOTES_ALTReps() {
        return this.getReps("CLOCK_AND_STATS_WITH_NOTES_ALT");
    }

    public List<NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT> getCLOCK_AND_STATS_WITH_NOTES_ALTAll() throws HL7Exception {
        return this.getAllAsList("CLOCK_AND_STATS_WITH_NOTES_ALT", NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT.class);
    }

    public void insertCLOCK_AND_STATS_WITH_NOTES_ALT(NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT structure, int rep) throws HL7Exception {
        super.insertRepetition("CLOCK_AND_STATS_WITH_NOTES_ALT", structure, rep);
    }

    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT insertCLOCK_AND_STATS_WITH_NOTES_ALT(int rep) throws HL7Exception {
        return (NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT)super.insertRepetition("CLOCK_AND_STATS_WITH_NOTES_ALT", rep);
    }

    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT removeCLOCK_AND_STATS_WITH_NOTES_ALT(int rep) throws HL7Exception {
        return (NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT)super.removeRepetition("CLOCK_AND_STATS_WITH_NOTES_ALT", rep);
    }
}

