/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.SQR_S25_PATIENT;
import ca.uhn.hl7v2.model.v251.group.SQR_S25_RESOURCES;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.SCH;
import ca.uhn.hl7v2.model.v251.segment.TQ1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQR_S25_SCHEDULE
extends AbstractGroup {
    public SQR_S25_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SCH.class, true, false, false);
            this.add(TQ1.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(SQR_S25_PATIENT.class, false, false, false);
            this.add(SQR_S25_RESOURCES.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SQR_S25_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public SCH getSCH() {
        SCH retVal = this.getTyped("SCH", SCH.class);
        return retVal;
    }

    public TQ1 getTQ1() {
        TQ1 retVal = this.getTyped("TQ1", TQ1.class);
        return retVal;
    }

    public TQ1 getTQ1(int rep) {
        TQ1 retVal = this.getTyped("TQ1", rep, TQ1.class);
        return retVal;
    }

    public int getTQ1Reps() {
        return this.getReps("TQ1");
    }

    public List<TQ1> getTQ1All() throws HL7Exception {
        return this.getAllAsList("TQ1", TQ1.class);
    }

    public void insertTQ1(TQ1 structure, int rep) throws HL7Exception {
        super.insertRepetition("TQ1", structure, rep);
    }

    public TQ1 insertTQ1(int rep) throws HL7Exception {
        return (TQ1)super.insertRepetition("TQ1", rep);
    }

    public TQ1 removeTQ1(int rep) throws HL7Exception {
        return (TQ1)super.removeRepetition("TQ1", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SQR_S25_PATIENT getPATIENT() {
        SQR_S25_PATIENT retVal = this.getTyped("PATIENT", SQR_S25_PATIENT.class);
        return retVal;
    }

    public SQR_S25_RESOURCES getRESOURCES() {
        SQR_S25_RESOURCES retVal = this.getTyped("RESOURCES", SQR_S25_RESOURCES.class);
        return retVal;
    }

    public SQR_S25_RESOURCES getRESOURCES(int rep) {
        SQR_S25_RESOURCES retVal = this.getTyped("RESOURCES", rep, SQR_S25_RESOURCES.class);
        return retVal;
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SQR_S25_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SQR_S25_RESOURCES.class);
    }

    public void insertRESOURCES(SQR_S25_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", structure, rep);
    }

    public SQR_S25_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SQR_S25_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SQR_S25_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SQR_S25_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

