/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.ORL_O34_SPECIMEN;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O34_PATIENT
extends AbstractGroup {
    public ORL_O34_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(ORL_O34_SPECIMEN.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORL_O34_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public ORL_O34_SPECIMEN getSPECIMEN() {
        ORL_O34_SPECIMEN retVal = this.getTyped("SPECIMEN", ORL_O34_SPECIMEN.class);
        return retVal;
    }

    public ORL_O34_SPECIMEN getSPECIMEN(int rep) {
        ORL_O34_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, ORL_O34_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<ORL_O34_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", ORL_O34_SPECIMEN.class);
    }

    public void insertSPECIMEN(ORL_O34_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public ORL_O34_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O34_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORL_O34_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O34_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

