/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.PL;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.VH;
import ca.uhn.hl7v2.model.v25.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LDP
extends AbstractSegment {
    public LDP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 200, new Object[]{this.getMessage()}, "Primary Key Value - LDP");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Location Department");
            this.add(IS.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(69)}, "Location Service");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Specialty Type");
            this.add(IS.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(4)}, "Valid Patient Classes");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Activation Date  LDP");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Inactivation Date - LDP");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Inactivated Reason");
            this.add(VH.class, false, 0, 80, new Object[]{this.getMessage()}, "Visiting Hours");
            this.add(XTN.class, false, 1, 250, new Object[]{this.getMessage()}, "Contact Phone");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Location Cost Center");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating LDP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValueLDP() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLdp1_PrimaryKeyValueLDP() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getLocationDepartment() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getLdp2_LocationDepartment() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public IS[] getLocationService() {
        IS[] retVal = (IS[])this.getTypedField(3, new IS[0]);
        return retVal;
    }

    public IS[] getLdp3_LocationService() {
        IS[] retVal = (IS[])this.getTypedField(3, new IS[0]);
        return retVal;
    }

    public int getLocationServiceReps() {
        return this.getReps(3);
    }

    public IS getLocationService(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public IS getLdp3_LocationService(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLdp3_LocationServiceReps() {
        return this.getReps(3);
    }

    public IS insertLocationService(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS insertLdp3_LocationService(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS removeLocationService(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public IS removeLdp3_LocationService(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public CE[] getSpecialtyType() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public CE[] getLdp4_SpecialtyType() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public int getSpecialtyTypeReps() {
        return this.getReps(4);
    }

    public CE getSpecialtyType(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public CE getLdp4_SpecialtyType(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getLdp4_SpecialtyTypeReps() {
        return this.getReps(4);
    }

    public CE insertSpecialtyType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE insertLdp4_SpecialtyType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE removeSpecialtyType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE removeLdp4_SpecialtyType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public IS[] getValidPatientClasses() {
        IS[] retVal = (IS[])this.getTypedField(5, new IS[0]);
        return retVal;
    }

    public IS[] getLdp5_ValidPatientClasses() {
        IS[] retVal = (IS[])this.getTypedField(5, new IS[0]);
        return retVal;
    }

    public int getValidPatientClassesReps() {
        return this.getReps(5);
    }

    public IS getValidPatientClasses(int rep) {
        IS retVal = (IS)this.getTypedField(5, rep);
        return retVal;
    }

    public IS getLdp5_ValidPatientClasses(int rep) {
        IS retVal = (IS)this.getTypedField(5, rep);
        return retVal;
    }

    public int getLdp5_ValidPatientClassesReps() {
        return this.getReps(5);
    }

    public IS insertValidPatientClasses(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(5, rep);
    }

    public IS insertLdp5_ValidPatientClasses(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(5, rep);
    }

    public IS removeValidPatientClasses(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(5, rep);
    }

    public IS removeLdp5_ValidPatientClasses(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(5, rep);
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getLdp6_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getActivationDateLDP() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getLdp7_ActivationDateLDP() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getInactivationDateLDP() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getLdp8_InactivationDateLDP() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getInactivatedReason() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getLdp9_InactivatedReason() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public VH[] getVisitingHours() {
        VH[] retVal = (VH[])this.getTypedField(10, new VH[0]);
        return retVal;
    }

    public VH[] getLdp10_VisitingHours() {
        VH[] retVal = (VH[])this.getTypedField(10, new VH[0]);
        return retVal;
    }

    public int getVisitingHoursReps() {
        return this.getReps(10);
    }

    public VH getVisitingHours(int rep) {
        VH retVal = (VH)this.getTypedField(10, rep);
        return retVal;
    }

    public VH getLdp10_VisitingHours(int rep) {
        VH retVal = (VH)this.getTypedField(10, rep);
        return retVal;
    }

    public int getLdp10_VisitingHoursReps() {
        return this.getReps(10);
    }

    public VH insertVisitingHours(int rep) throws HL7Exception {
        return (VH)super.insertRepetition(10, rep);
    }

    public VH insertLdp10_VisitingHours(int rep) throws HL7Exception {
        return (VH)super.insertRepetition(10, rep);
    }

    public VH removeVisitingHours(int rep) throws HL7Exception {
        return (VH)super.removeRepetition(10, rep);
    }

    public VH removeLdp10_VisitingHours(int rep) throws HL7Exception {
        return (VH)super.removeRepetition(10, rep);
    }

    public XTN getContactPhone() {
        XTN retVal = (XTN)this.getTypedField(11, 0);
        return retVal;
    }

    public XTN getLdp11_ContactPhone() {
        XTN retVal = (XTN)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getLocationCostCenter() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getLdp12_LocationCostCenter() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new IS(this.getMessage(), new Integer(69));
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(4));
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new VH(this.getMessage());
            }
            case 10: {
                return new XTN(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

