/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CQ;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TQ;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class INV
extends AbstractSegment {
    public INV(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Substance Identifier");
            this.add(CE.class, true, 0, 250, new Object[]{this.getMessage()}, "Substance Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Substance Type");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Container Identifier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Container Carrier Identifier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Position on Carrier");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Initial Quantity");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Current Quantity");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Available Quantity");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Consumption Quantity");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Quantity Units");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Expiration Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "First Used Date/Time");
            this.add(TQ.class, false, 1, 200, new Object[]{this.getMessage()}, "On Board Stability Duration");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Test/Fluid Identifier(s)");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Manufacturer Lot Number");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Manufacturer Identifier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Supplier Identifier");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "On Board Stability Time");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Target Value");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating INV - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getSubstanceIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getInv1_SubstanceIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getSubstanceStatus() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getInv2_SubstanceStatus() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getSubstanceStatusReps() {
        return this.getReps(2);
    }

    public CE getSubstanceStatus(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getInv2_SubstanceStatus(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getInv2_SubstanceStatusReps() {
        return this.getReps(2);
    }

    public CE insertSubstanceStatus(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertInv2_SubstanceStatus(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeSubstanceStatus(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removeInv2_SubstanceStatus(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE getSubstanceType() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getInv3_SubstanceType() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getInventoryContainerIdentifier() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getInv4_InventoryContainerIdentifier() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getContainerCarrierIdentifier() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getInv5_ContainerCarrierIdentifier() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getPositionOnCarrier() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getInv6_PositionOnCarrier() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getInitialQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getInv7_InitialQuantity() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getCurrentQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getInv8_CurrentQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getAvailableQuantity() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getInv9_AvailableQuantity() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getConsumptionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getInv10_ConsumptionQuantity() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getQuantityUnits() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getInv11_QuantityUnits() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getExpirationDateTime() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getInv12_ExpirationDateTime() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getFirstUsedDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getInv13_FirstUsedDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TQ getOnBoardStabilityDuration() {
        TQ retVal = (TQ)this.getTypedField(14, 0);
        return retVal;
    }

    public TQ getInv14_OnBoardStabilityDuration() {
        TQ retVal = (TQ)this.getTypedField(14, 0);
        return retVal;
    }

    public CE[] getTestFluidIdentifierS() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public CE[] getInv15_TestFluidIdentifierS() {
        CE[] retVal = (CE[])this.getTypedField(15, new CE[0]);
        return retVal;
    }

    public int getTestFluidIdentifierSReps() {
        return this.getReps(15);
    }

    public CE getTestFluidIdentifierS(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public CE getInv15_TestFluidIdentifierS(int rep) {
        CE retVal = (CE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getInv15_TestFluidIdentifierSReps() {
        return this.getReps(15);
    }

    public CE insertTestFluidIdentifierS(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE insertInv15_TestFluidIdentifierS(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE removeTestFluidIdentifierS(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public CE removeInv15_TestFluidIdentifierS(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public ST getManufacturerLotNumber() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getInv16_ManufacturerLotNumber() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getManufacturerIdentifier() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getInv17_ManufacturerIdentifier() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getSupplierIdentifier() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getInv18_SupplierIdentifier() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ getOnBoardStabilityTime() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getInv19_OnBoardStabilityTime() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getTargetValue() {
        CQ retVal = (CQ)this.getTypedField(20, 0);
        return retVal;
    }

    public CQ getInv20_TargetValue() {
        CQ retVal = (CQ)this.getTypedField(20, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new TS(this.getMessage());
            }
            case 12: {
                return new TS(this.getMessage());
            }
            case 13: {
                return new TQ(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new CQ(this.getMessage());
            }
            case 19: {
                return new CQ(this.getMessage());
            }
        }
        return null;
    }
}

