/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.OUL_R22_PATIENT;
import ca.uhn.hl7v2.model.v25.group.OUL_R22_SPECIMEN;
import ca.uhn.hl7v2.model.v25.group.OUL_R22_VISIT;
import ca.uhn.hl7v2.model.v25.segment.DSC;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUL_R22
extends AbstractMessage {
    public OUL_R22() {
        this(new DefaultModelClassFactory());
    }

    public OUL_R22(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NTE.class, false, false);
            this.add(OUL_R22_PATIENT.class, false, false);
            this.add(OUL_R22_VISIT.class, false, false);
            this.add(OUL_R22_SPECIMEN.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OUL_R22 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public OUL_R22_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", OUL_R22_PATIENT.class);
    }

    public OUL_R22_VISIT getVISIT() {
        return this.getTyped("VISIT", OUL_R22_VISIT.class);
    }

    public OUL_R22_SPECIMEN getSPECIMEN() {
        return this.getTyped("SPECIMEN", OUL_R22_SPECIMEN.class);
    }

    public OUL_R22_SPECIMEN getSPECIMEN(int rep) {
        return this.getTyped("SPECIMEN", rep, OUL_R22_SPECIMEN.class);
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OUL_R22_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OUL_R22_SPECIMEN.class);
    }

    public void insertSPECIMEN(OUL_R22_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public OUL_R22_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OUL_R22_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OUL_R22_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OUL_R22_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

