/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.VXR_V03_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.VXR_V03_TIMING;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.model.v25.segment.RXA;
import ca.uhn.hl7v2.model.v25.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXR_V03_ORDER
extends AbstractGroup {
    public VXR_V03_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(VXR_V03_TIMING.class, false, true, false);
            this.add(RXA.class, true, false, false);
            this.add(RXR.class, false, false, false);
            this.add(VXR_V03_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating VXR_V03_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public VXR_V03_TIMING getTIMING() {
        VXR_V03_TIMING retVal = this.getTyped("TIMING", VXR_V03_TIMING.class);
        return retVal;
    }

    public VXR_V03_TIMING getTIMING(int rep) {
        VXR_V03_TIMING retVal = this.getTyped("TIMING", rep, VXR_V03_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<VXR_V03_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", VXR_V03_TIMING.class);
    }

    public void insertTIMING(VXR_V03_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public VXR_V03_TIMING insertTIMING(int rep) throws HL7Exception {
        return (VXR_V03_TIMING)super.insertRepetition("TIMING", rep);
    }

    public VXR_V03_TIMING removeTIMING(int rep) throws HL7Exception {
        return (VXR_V03_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RXA getRXA() {
        RXA retVal = this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public VXR_V03_OBSERVATION getOBSERVATION() {
        VXR_V03_OBSERVATION retVal = this.getTyped("OBSERVATION", VXR_V03_OBSERVATION.class);
        return retVal;
    }

    public VXR_V03_OBSERVATION getOBSERVATION(int rep) {
        VXR_V03_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, VXR_V03_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<VXR_V03_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", VXR_V03_OBSERVATION.class);
    }

    public void insertOBSERVATION(VXR_V03_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public VXR_V03_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (VXR_V03_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public VXR_V03_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (VXR_V03_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

