/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CQ;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM4
extends AbstractSegment {
    public OM4(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/ Observation Master File");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(170)}, "Derived Specimen");
            this.add(TX.class, false, 1, 60, new Object[]{this.getMessage()}, "Container Description");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Container Volume");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Container Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Specimen");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Additive");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Preparation");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Special Handling Requirements");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Normal Collection Volume");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Minimum Collection Volume");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Specimen Requirements");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(27)}, "Specimen Priorities");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Specimen Retention Time");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OM4 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm41_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getDerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getOm42_DerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public TX getContainerDescription() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public TX getOm43_ContainerDescription() {
        TX retVal = (TX)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getContainerVolume() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getOm44_ContainerVolume() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getContainerUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getOm45_ContainerUnits() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getSpecimen() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getOm46_Specimen() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getAdditive() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getOm47_Additive() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getPreparation() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getOm48_Preparation() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getSpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public TX getOm49_SpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getNormalCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ getOm410_NormalCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ getMinimumCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getOm411_MinimumCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(11, 0);
        return retVal;
    }

    public TX getSpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(12, 0);
        return retVal;
    }

    public TX getOm412_SpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getSpecimenPriorities() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getOm413_SpecimenPriorities() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public CQ getSpecimenRetentionTime() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    public CQ getOm414_SpecimenRetentionTime() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(170));
            }
            case 2: {
                return new TX(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new TX(this.getMessage());
            }
            case 8: {
                return new TX(this.getMessage());
            }
            case 9: {
                return new CQ(this.getMessage());
            }
            case 10: {
                return new CQ(this.getMessage());
            }
            case 11: {
                return new TX(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(27));
            }
            case 13: {
                return new CQ(this.getMessage());
            }
        }
        return null;
    }
}

